; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Top10"
!define PRODUCT_VERSION "0.4"
!define PRODUCT_PUBLISHER "Top10 & co"
!define PRODUCT_WEB_SITE "http://www.top10-racing.org"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\top10.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
;!define MUI_ICON "top10.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\top10.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Top10-Setup.exe"
InstallDir "$PROGRAMFILES\Top10"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "Main files" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "top10.exe"
  CreateDirectory "$SMPROGRAMS\Top10"
  CreateShortCut "$SMPROGRAMS\Top10\Top10.lnk" "$INSTDIR\top10.exe"
  CreateShortCut "$DESKTOP\Top10.lnk" "$INSTDIR\top10.exe"
  SetOutPath "$INSTDIR\data\sounds"
  SetOverwrite try
  File "data\sounds\navigate.wav"
  File "data\sounds\rolling.wav"
  File "data\sounds\select.wav"
  File "data\sounds\skid_side.wav"
  File "data\sounds\tac.wav"
  File "data\sounds\tic.wav"
  File "data\sounds\tyre.wav"
  SetOutPath "$INSTDIR\data"
  File "data\menus.ogg"
  SetOutPath "$INSTDIR\data\defaults"
  File "data\defaults\inputs"
  SetOverwrite off
  SetOutPath "$APPDATA\top10"
  File "data\defaults\inputs"
  SetOverwrite try
  SetOutPath "$INSTDIR\data\kart_data\default"
  File "data\kart_data\default\default.parts"
  File "data\kart_data\default\scene.xml"
  File "data\kart_data\default\default.physx"
  File "data\kart_data\default\kart.3ds"
  File "data\kart_data\default\setups.xml"
  File "data\kart_data\default\sounds.xml"
  SetOutPath "$INSTDIR\data\kart_data\default\textures"
  File "data\kart_data\default\textures\casque.tga"
  File "data\kart_data\default\textures\chassis.tga"
  File "data\kart_data\default\textures\moteur.tga"
  File "data\kart_data\default\textures\pilote.tga"
  File "data\kart_data\default\textures\pilote1.tga"
  File "data\kart_data\default\textures\ponton_d.tga"
  File "data\kart_data\default\textures\ponton_g.tga"
  File "data\kart_data\default\textures\radiateu.tga"
  File "data\kart_data\default\textures\reservoi.tga"
  File "data\kart_data\default\textures\roues.tga"
  File "data\kart_data\default\textures\spoiler.tga"
  File "data\kart_data\default\textures\volant.tga"
  File "data\kart_data\default\textures\plancher.tga"
  SetOutPath "$INSTDIR\data\kart_data\default\sounds"
  File "data\kart_data\default\sounds\Rotax_idle_in.wav"
  File "data\kart_data\default\sounds\kart_offhigh_in.wav"
  File "data\kart_data\default\sounds\kart_onhigh_in.wav"
  File "data\kart_data\default\sounds\Rotax_start_in.wav"
  File "data\kart_data\default\sounds\kart_offlow_in.wav"
  File "data\kart_data\default\sounds\kart_onlow_in.wav"
  SetOutPath "$INSTDIR\data\meshes\kart+paddock\kart"
  File "data\meshes\kart+paddock\kart\body.tga"
  File "data\meshes\kart+paddock\kart\driver.tga"
  File "data\meshes\kart+paddock\kart\helmet.tga"
  File "data\meshes\kart+paddock\kart\tube01.tga"
  File "data\meshes\kart+paddock\kart\tyres.tga"
  File "data\meshes\kart+paddock\kart\cockpit.tga"
  File "data\meshes\kart+paddock\kart\engine.tga"
  File "data\meshes\kart+paddock\kart\kart.3ds"
  File "data\meshes\kart+paddock\kart\tube02.tga"
  SetOutPath "$INSTDIR\data\meshes\kart+paddock\paddock"
  File "data\meshes\kart+paddock\paddock\carriage.tga"
  File "data\meshes\kart+paddock\paddock\floor.tga"
  File "data\meshes\kart+paddock\paddock\paddock.3ds"
  SetOutPath "$INSTDIR\data\fonts"
  File "data\fonts\rockfont.txf"
  File "data\fonts\curlfont.txf"
  File "data\fonts\default.txf"
  File "data\fonts\haeberli.txf"
  File "data\fonts\sorority.txf"
  File "data\fonts\gentexfont.c"
  SetOutPath "$INSTDIR\data\textures\Sunset"
  File "data\textures\Sunset\back.jpg"
  File "data\textures\Sunset\bottom.jpg"
  File "data\textures\Sunset\front.jpg"
  File "data\textures\Sunset\left.jpg"
  File "data\textures\Sunset\promo_sunset.jpg"
  File "data\textures\Sunset\ReadMe.txt"
  File "data\textures\Sunset\right.jpg"
  File "data\textures\Sunset\top.jpg"
  SetOutPath "$INSTDIR\data\textures\Orient"
  File "data\textures\Sunset\back.jpg"
  File "data\textures\Sunset\bottom.jpg"
  File "data\textures\Sunset\front.jpg"
  File "data\textures\Sunset\left.jpg"
  File "data\textures\Sunset\right.jpg"
  File "data\textures\Sunset\top.jpg"
  SetOutPath "$INSTDIR\data\textures\skyboxsun25degtest"
  File "data\textures\skyboxsun25degtest\COPYING.txt"
  File "data\textures\skyboxsun25degtest\back.jpg"
  File "data\textures\skyboxsun25degtest\bottom.jpg"
  File "data\textures\skyboxsun25degtest\front.jpg"
  File "data\textures\skyboxsun25degtest\left.jpg"
  File "data\textures\skyboxsun25degtest\right.jpg"
  File "data\textures\skyboxsun25degtest\top.jpg"
  SetOutPath "$INSTDIR\data\textures\skyboxsun5deg"
  File "data\textures\skyboxsun5deg\COPYING.txt"
  File "data\textures\skyboxsun5deg\back.jpg"
  File "data\textures\skyboxsun5deg\bottom.jpg"
  File "data\textures\skyboxsun5deg\front.jpg"
  File "data\textures\skyboxsun5deg\left.jpg"
  File "data\textures\skyboxsun5deg\right.jpg"
  File "data\textures\skyboxsun5deg\top.jpg"
  SetOutPath "$INSTDIR\data\textures\skyboxsun5deg2"
  File "data\textures\skyboxsun5deg2\COPYING.txt"
  File "data\textures\skyboxsun5deg2\back.jpg"
  File "data\textures\skyboxsun5deg2\bottom.jpg"
  File "data\textures\skyboxsun5deg2\front.jpg"
  File "data\textures\skyboxsun5deg2\left.jpg"
  File "data\textures\skyboxsun5deg2\right.jpg"
  File "data\textures\skyboxsun5deg2\top.jpg"
  SetOutPath "$INSTDIR\data\textures\skyboxsun45deg"
  File "data\textures\skyboxsun45deg\COPYING.txt"
  File "data\textures\skyboxsun45deg\back.jpg"
  File "data\textures\skyboxsun45deg\bottom.jpg"
  File "data\textures\skyboxsun45deg\front.jpg"
  File "data\textures\skyboxsun45deg\left.jpg"
  File "data\textures\skyboxsun45deg\right.jpg"
  File "data\textures\skyboxsun45deg\top.jpg"
  SetOutPath "$INSTDIR\data\textures\"
  File "data\textures\background.jpg"
  SetOutPath "$INSTDIR\data"
  File "data\COPYING.txt"
  SetOutPath "$INSTDIR\Microsoft.VC80.CRT"
  File "Microsoft.VC80.CRT\Microsoft.VC80.CRT.manifest"
  File "Microsoft.VC80.CRT\msvcm80.dll"
  File "Microsoft.VC80.CRT\msvcp80.dll"
  File "Microsoft.VC80.CRT\msvcr80.dll"
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "SDL.dll"
  File "SDL_image.dll"
  File "cal3d.dll"
  File "TODO.txt"
  File "README.txt"
  File "COPYING.txt"
  File "ChangeLog.txt"
  File "BUGS.txt"
  File "AUTHORS.txt"
SectionEnd

Section "TrackED" SEC02
  File "tracked.exe"
  File "Qt3Support4.dll"
  File "QtCore4.dll"
  File "QtDesigner4.dll"
  File "QtGui4.dll"
  File "QtNetwork4.dll"
  File "QtOpenGL4.dll"
  File "QtSql4.dll"
  File "QtSvg4.dll"
  File "QtTest4.dll"
  File "QtXml4.dll"
  CreateShortCut "$SMPROGRAMS\Top10\Tracked.lnk" "$INSTDIR\tracked.exe"
  CreateShortCut "$DESKTOP\Tracked.lnk" "$INSTDIR\tracked.exe"
SectionEnd

Section "MaisonBlanche" SEC03
  SetOverwrite try
  SetOutPath "$INSTDIR\data\track_data\MaisonBlanche"
  File "data\track_data\MaisonBlanche\*.*"
  SetOutPath "$INSTDIR\data\track_data\MaisonBlanche\textures"
  File "data\track_data\MaisonBlanche\textures\*.*"
  SetOutPath "$INSTDIR\data\track_data\MaisonBlanche\textures\skybox"
  File "data\track_data\MaisonBlanche\textures\skybox\*.*"
SectionEnd

Section "Laval" SEC04
  SetOverwrite try
  SetOutPath "$INSTDIR\data\track_data\Laval"
  File "data\track_data\Laval\*.*"
  SetOutPath "$INSTDIR\data\track_data\Laval\textures"
  File "data\track_data\Laval\textures\*.*"
  SetOutPath "$INSTDIR\data\track_data\Laval\textures\skybox"
  File "data\track_data\Laval\textures\skybox\*.*"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\Top10\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\Top10\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\top10.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\top10.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "The game"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "The track editor"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "Track: MaisonBlanche"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "Track: Laval"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"  
  Delete "$SMPROGRAMS\Top10\Uninstall.lnk"
  Delete "$SMPROGRAMS\Top10\Website.lnk"
  Delete "$DESKTOP\Tracked.lnk"
  Delete "$SMPROGRAMS\Top10\Tracked.lnk"
  Delete "$DESKTOP\Top10.lnk"
  Delete "$SMPROGRAMS\Top10\Top10.lnk"
  Delete "$SMPROGRAMS\Top10\*.*"

  RMDir "$SMPROGRAMS\Top10"
  RMDir "$INSTDIR\data\textures\Sunset"
  RMDir "$INSTDIR\data\textures"
  RMDir "$INSTDIR\data\sounds"
  RMDir "$INSTDIR\data\meshes"
  RMDir "$INSTDIR\data\kart_data\default\textures"
  RMDir "$INSTDIR\data\kart_data\default"
  RMDir "$INSTDIR\data\kart_data\fastsoft"
  RMDir "$INSTDIR\data\fonts"
  RMDir "$INSTDIR\data\defaults"
  RMDir "$INSTDIR\data\track_data\MaisonBlanche\textures"
  RMDir "$INSTDIR\data\track_data\MaisonBlanche\skybox"
  RMDir "$INSTDIR\data\track_data\MaisonBlanche"
  RMDir "$INSTDIR\data\track_data\Laval\textures"
  RMDir "$INSTDIR\data\track_data\Laval\skybox"
  RMDir "$INSTDIR\data\track_data\Laval"
  RMDir "$INSTDIR\data\track_data"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd