/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Quaqua13ColorChooserUI;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class Quaqua14ColorChooserUI
extends Quaqua13ColorChooserUI {
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    private MouseListener previewMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua14ColorChooserUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.chooser.applyComponentOrientation(c.getComponentOrientation());
    }

    protected void installDefaults() {
        super.installDefaults();
        TransferHandler th = this.chooser.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.previewMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (Quaqua14ColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler th = Quaqua14ColorChooserUI.this.chooser.getTransferHandler();
                    th.exportAsDrag(Quaqua14ColorChooserUI.this.chooser, e, 1);
                }
            }
        };
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        super.installPreviewPanel();
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("chooserPanels")) {
                int i;
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (i = 0; i < oldPanels.length; ++i) {
                    Container wrapper;
                    if (oldPanels[i] == null || (wrapper = oldPanels[i].getParent()) == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(Quaqua14ColorChooserUI.this.chooser);
                }
                Quaqua14ColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    Quaqua14ColorChooserUI.this.mainPanel.addColorChooserPanel(newPanels[i]);
                }
                Quaqua14ColorChooserUI.this.chooser.applyComponentOrientation(Quaqua14ColorChooserUI.this.chooser.getComponentOrientation());
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    newPanels[i].installChooserPanel(Quaqua14ColorChooserUI.this.chooser);
                }
            }
            if (name.equals("previewPanel") && e.getNewValue() != Quaqua14ColorChooserUI.this.previewPanel) {
                Quaqua14ColorChooserUI.this.installPreviewPanel();
            }
            if (name.equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JColorChooser cc = (JColorChooser)e.getSource();
                if (o != (ComponentOrientation)e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                    cc.updateUI();
                }
            }
        }
    }
}

