/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.CachedPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;

public class Quaqua14PlacardButtonBorder
extends CachedPainter
implements Border {
    private static final Color[] defaultColors = new Color[]{new Color(0xD8D8D8), new Color(0x7D7D7D), new Color(0x979797), new Color(0x979797), new Color(0xF5F5F5), new Color(0xFEFEFE), new Color(0xF3F3F3), new Color(0xFDFDFD), new Color(0xF3F3F3), new Color(0xE6E6E6)};
    private static final Color[] selectedColors = new Color[]{new Color(0xD8D8D8), new Color(0x424242), new Color(0x565656), new Color(0x515151), new Color(0xB9B9B9), new Color(0xA5A5A5), new Color(0x969696), new Color(0xA5A5A5), new Color(0x9E9E9E), new Color(0x969696)};
    private static final Color[] disabledColors = new Color[]{new Color(0xD8D8D8), new Color(0x7D7D7D), new Color(0x979797), new Color(0x979797), new Color(0xF5F5F5), new Color(0xFEFEFE), new Color(0xF3F3F3), new Color(0xFDFDFD), new Color(0xF3F3F3), new Color(0xE6E6E6)};
    private static final Color[] disabledSelectedColors = new Color[]{new Color(0xD8D8D8), new Color(0x424242), new Color(0x565656), new Color(0x515151), new Color(0xB9B9B9), new Color(0xA5A5A5), new Color(0x969696), new Color(0xA5A5A5), new Color(0x9E9E9E), new Color(0x969696)};

    public Quaqua14PlacardButtonBorder() {
        super(8);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(2, 1, 2, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 3);
        }
        return config.createCompatibleImage(w, h, 3);
    }

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        Object[] colors;
        if (height <= 0 || width <= 0) {
            return;
        }
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            colors = button.isEnabled() ? (model.isSelected() || model.isArmed() && model.isPressed() ? selectedColors : defaultColors) : (model.isSelected() ? disabledSelectedColors : disabledColors);
        } else {
            colors = c.isEnabled() ? defaultColors : disabledColors;
        }
        this.paint(c, gr, x, y, width, height, colors);
    }

    protected void paintToImage(Component c, Graphics gr, int width, int height, Object[] args) {
        Graphics2D g = (Graphics2D)gr.create();
        Color[] colors = (Color[])args;
        Paint oldPaint = g.getPaint();
        g.setPaint(new GradientPaint(0.0f, 2.0f, colors[5], 0.0f, height - 3, colors[6]));
        g.drawLine(1, 2, 1, height - 3);
        g.drawLine(width - 2, 2, width - 2, height - 3);
        int sheight = (int)((double)height * 0.45);
        g.setPaint(new GradientPaint(0.0f, 2.0f, colors[7], 0.0f, sheight, colors[8]));
        g.fillRect(2, 2, width - 4, sheight - 1);
        g.setColor(colors[0]);
        g.drawLine(0, 0, width - 1, 0);
        g.setColor(colors[1]);
        g.drawLine(0, 1, width - 1, 1);
        g.setColor(colors[2]);
        g.drawLine(0, 2, 0, height - 3);
        g.drawLine(width - 1, 2, width - 1, height - 3);
        g.setColor(colors[3]);
        g.drawLine(0, height - 2, width - 1, height - 2);
        g.setColor(colors[4]);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.setColor(colors[9]);
        g.fillRect(2, sheight + 1, width - 4, height - sheight - 3);
        g.setPaint(oldPaint);
        g.dispose();
    }
}

