/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.tools.CheckBoxList;
import processing.core.PApplet;
import processing.core.PFont;

class CharacterSelector
extends JFrame {
    JRadioButton defaultCharsButton;
    JRadioButton allCharsButton;
    JRadioButton unicodeCharsButton;
    JScrollPane unicodeBlockScroller;
    JList charsetList = new CheckBoxList();
    static final String[] BLOCKS = new String[]{"0000..007F; Basic Latin", "0080..00FF; Latin-1 Supplement", "0100..017F; Latin Extended-A", "0180..024F; Latin Extended-B", "0250..02AF; IPA Extensions", "02B0..02FF; Spacing Modifier Letters", "0300..036F; Combining Diacritical Marks", "0370..03FF; Greek and Coptic", "0400..04FF; Cyrillic", "0500..052F; Cyrillic Supplement", "0530..058F; Armenian", "0590..05FF; Hebrew", "0600..06FF; Arabic", "0700..074F; Syriac", "0750..077F; Arabic Supplement", "0780..07BF; Thaana", "07C0..07FF; NKo", "0800..083F; Samaritan", "0900..097F; Devanagari", "0980..09FF; Bengali", "0A00..0A7F; Gurmukhi", "0A80..0AFF; Gujarati", "0B00..0B7F; Oriya", "0B80..0BFF; Tamil", "0C00..0C7F; Telugu", "0C80..0CFF; Kannada", "0D00..0D7F; Malayalam", "0D80..0DFF; Sinhala", "0E00..0E7F; Thai", "0E80..0EFF; Lao", "0F00..0FFF; Tibetan", "1000..109F; Myanmar", "10A0..10FF; Georgian", "1100..11FF; Hangul Jamo", "1200..137F; Ethiopic", "1380..139F; Ethiopic Supplement", "13A0..13FF; Cherokee", "1400..167F; Unified Canadian Aboriginal Syllabics", "1680..169F; Ogham", "16A0..16FF; Runic", "1700..171F; Tagalog", "1720..173F; Hanunoo", "1740..175F; Buhid", "1760..177F; Tagbanwa", "1780..17FF; Khmer", "1800..18AF; Mongolian", "18B0..18FF; Unified Canadian Aboriginal Syllabics Extended", "1900..194F; Limbu", "1950..197F; Tai Le", "1980..19DF; New Tai Lue", "19E0..19FF; Khmer Symbols", "1A00..1A1F; Buginese", "1A20..1AAF; Tai Tham", "1B00..1B7F; Balinese", "1B80..1BBF; Sundanese", "1C00..1C4F; Lepcha", "1C50..1C7F; Ol Chiki", "1CD0..1CFF; Vedic Extensions", "1D00..1D7F; Phonetic Extensions", "1D80..1DBF; Phonetic Extensions Supplement", "1DC0..1DFF; Combining Diacritical Marks Supplement", "1E00..1EFF; Latin Extended Additional", "1F00..1FFF; Greek Extended", "2000..206F; General Punctuation", "2070..209F; Superscripts and Subscripts", "20A0..20CF; Currency Symbols", "20D0..20FF; Combining Diacritical Marks for Symbols", "2100..214F; Letterlike Symbols", "2150..218F; Number Forms", "2190..21FF; Arrows", "2200..22FF; Mathematical Operators", "2300..23FF; Miscellaneous Technical", "2400..243F; Control Pictures", "2440..245F; Optical Character Recognition", "2460..24FF; Enclosed Alphanumerics", "2500..257F; Box Drawing", "2580..259F; Block Elements", "25A0..25FF; Geometric Shapes", "2600..26FF; Miscellaneous Symbols", "2700..27BF; Dingbats", "27C0..27EF; Miscellaneous Mathematical Symbols-A", "27F0..27FF; Supplemental Arrows-A", "2800..28FF; Braille Patterns", "2900..297F; Supplemental Arrows-B", "2980..29FF; Miscellaneous Mathematical Symbols-B", "2A00..2AFF; Supplemental Mathematical Operators", "2B00..2BFF; Miscellaneous Symbols and Arrows", "2C00..2C5F; Glagolitic", "2C60..2C7F; Latin Extended-C", "2C80..2CFF; Coptic", "2D00..2D2F; Georgian Supplement", "2D30..2D7F; Tifinagh", "2D80..2DDF; Ethiopic Extended", "2DE0..2DFF; Cyrillic Extended-A", "2E00..2E7F; Supplemental Punctuation", "2E80..2EFF; CJK Radicals Supplement", "2F00..2FDF; Kangxi Radicals", "2FF0..2FFF; Ideographic Description Characters", "3000..303F; CJK Symbols and Punctuation", "3040..309F; Hiragana", "30A0..30FF; Katakana", "3100..312F; Bopomofo", "3130..318F; Hangul Compatibility Jamo", "3190..319F; Kanbun", "31A0..31BF; Bopomofo Extended", "31C0..31EF; CJK Strokes", "31F0..31FF; Katakana Phonetic Extensions", "3200..32FF; Enclosed CJK Letters and Months", "3300..33FF; CJK Compatibility", "3400..4DBF; CJK Unified Ideographs Extension A", "4DC0..4DFF; Yijing Hexagram Symbols", "4E00..9FFF; CJK Unified Ideographs", "A000..A48F; Yi Syllables", "A490..A4CF; Yi Radicals", "A4D0..A4FF; Lisu", "A500..A63F; Vai", "A640..A69F; Cyrillic Extended-B", "A6A0..A6FF; Bamum", "A700..A71F; Modifier Tone Letters", "A720..A7FF; Latin Extended-D", "A800..A82F; Syloti Nagri", "A830..A83F; Common Indic Number Forms", "A840..A87F; Phags-pa", "A880..A8DF; Saurashtra", "A8E0..A8FF; Devanagari Extended", "A900..A92F; Kayah Li", "A930..A95F; Rejang", "A960..A97F; Hangul Jamo Extended-A", "A980..A9DF; Javanese", "AA00..AA5F; Cham", "AA60..AA7F; Myanmar Extended-A", "AA80..AADF; Tai Viet", "ABC0..ABFF; Meetei Mayek", "AC00..D7AF; Hangul Syllables", "D7B0..D7FF; Hangul Jamo Extended-B", "D800..DB7F; High Surrogates", "DB80..DBFF; High Private Use Surrogates", "DC00..DFFF; Low Surrogates", "E000..F8FF; Private Use Area", "F900..FAFF; CJK Compatibility Ideographs", "FB00..FB4F; Alphabetic Presentation Forms", "FB50..FDFF; Arabic Presentation Forms-A", "FE00..FE0F; Variation Selectors", "FE10..FE1F; Vertical Forms", "FE20..FE2F; Combining Half Marks", "FE30..FE4F; CJK Compatibility Forms", "FE50..FE6F; Small Form Variants", "FE70..FEFF; Arabic Presentation Forms-B", "FF00..FFEF; Halfwidth and Fullwidth Forms", "FFF0..FFFF; Specials"};
    static String[] blockNames;
    static int[] blockStart;
    static int[] blockStop;

    public CharacterSelector() {
        super("Character Selector");
        DefaultListModel<JCheckBox> defaultListModel = new DefaultListModel<JCheckBox>();
        this.charsetList.setModel(defaultListModel);
        for (String object2 : blockNames) {
            defaultListModel.addElement(new JCheckBox(object2));
        }
        this.unicodeBlockScroller = new JScrollPane(this.charsetList, 22, 31);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(13, 13, 13, 13));
        container.add((Component)jPanel, "Center");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = "Default characters will include most bitmaps for Mac OS\nand Windows Latin scripts. Including all characters may\nrequire large amounts of memory for all of the bitmaps.\nFor greater control, you can select specific Unicode blocks.";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setBorder(new EmptyBorder(13, 8, 13, 8));
        jTextArea.setBackground(null);
        jTextArea.setEditable(false);
        jTextArea.setHighlighter(null);
        jTextArea.setFont(new Font("Dialog", 0, 12));
        jPanel.add(jTextArea);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterSelector.this.charsetList.setEnabled(CharacterSelector.this.unicodeCharsButton.isSelected());
            }
        };
        this.defaultCharsButton = new JRadioButton("Default Characters");
        this.allCharsButton = new JRadioButton("All Characters");
        this.unicodeCharsButton = new JRadioButton("Specific Unicode Blocks");
        this.defaultCharsButton.addActionListener(actionListener);
        this.allCharsButton.addActionListener(actionListener);
        this.unicodeCharsButton.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultCharsButton);
        buttonGroup.add(this.allCharsButton);
        buttonGroup.add(this.unicodeCharsButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.defaultCharsButton);
        jPanel2.add(this.allCharsButton);
        jPanel2.add(this.unicodeCharsButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(13));
        this.defaultCharsButton.setSelected(true);
        this.charsetList.setEnabled(false);
        jPanel.add(this.unicodeBlockScroller);
        jPanel.add(Box.createVerticalStrut(8));
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterSelector.this.setVisible(false);
            }
        });
        jButton.setEnabled(true);
        jPanel4.add(jButton);
        jPanel.add(jPanel4);
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterSelector.this.setVisible(false);
            }
        };
        Base.registerWindowCloseKeys(jRootPane, actionListener2);
        Base.setIcon(this);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    protected char[] getCharacters() {
        if (this.defaultCharsButton.isSelected()) {
            return PFont.CHARSET;
        }
        char[] cArray = new char[65536];
        if (this.allCharsButton.isSelected()) {
            for (int i = 0; i < 65535; ++i) {
                cArray[i] = (char)i;
            }
        } else {
            DefaultListModel defaultListModel = (DefaultListModel)this.charsetList.getModel();
            int n = 0;
            for (int i = 0; i < BLOCKS.length; ++i) {
                if (!((JCheckBox)defaultListModel.get(i)).isSelected()) continue;
                for (int j = blockStart[i]; j <= blockStop[i]; ++j) {
                    cArray[n++] = (char)j;
                }
            }
            cArray = PApplet.subset((char[])cArray, (int)0, (int)n);
        }
        return cArray;
    }

    static {
        int n = BLOCKS.length;
        blockNames = new String[n];
        blockStart = new int[n];
        blockStop = new int[n];
        for (int i = 0; i < n; ++i) {
            String string = BLOCKS[i];
            CharacterSelector.blockStart[i] = PApplet.unhex((String)string.substring(0, 4));
            CharacterSelector.blockStop[i] = PApplet.unhex((String)string.substring(6, 10));
            CharacterSelector.blockNames[i] = string.substring(12);
        }
    }
}

