/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import processing.app.debug.MessageConsumer;

public class MessageSiphon
implements Runnable {
    BufferedReader streamReader;
    Thread thread;
    MessageConsumer consumer;

    public MessageSiphon(InputStream inputStream, MessageConsumer messageConsumer) {
        this.streamReader = new BufferedReader(new InputStreamReader(inputStream));
        this.consumer = messageConsumer;
        this.thread = new Thread(this);
        this.thread.setPriority(9);
        this.thread.start();
    }

    public void run() {
        try {
            String string;
            while ((string = this.streamReader.readLine()) != null) {
                this.consumer.message(string + "\n");
            }
            this.thread = null;
        }
        catch (NullPointerException nullPointerException) {
            this.thread = null;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null || string.indexOf("Bad file descriptor") == -1) {
                exception.printStackTrace();
            }
            this.thread = null;
        }
    }

    public Thread getThread() {
        return this.thread;
    }
}

