/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.text.BadLocationException;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.im.CompositionTextPainter;

public class CompositionTextManager {
    private JEditTextArea textArea;
    private String prevComposeString;
    private int prevCommittedCount;
    private boolean isInputProcess;
    private int initialCaretPosition;
    public static final int COMPOSING_UNDERBAR_HEIGHT = 5;

    public CompositionTextManager(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        this.prevComposeString = "";
        this.isInputProcess = false;
        this.prevCommittedCount = 0;
    }

    public boolean getIsInputProcess() {
        return this.isInputProcess;
    }

    public void beginCompositionText(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.isInputProcess = true;
        this.prevComposeString = "";
        this.initialCaretPosition = this.textArea.getCaretPosition();
        this.processCompositionText(attributedCharacterIterator, n);
    }

    public void processCompositionText(AttributedCharacterIterator attributedCharacterIterator, int n) {
        int n2;
        int n3 = this.initialCaretPosition + n;
        CompositionTextPainter compositionTextPainter = this.textArea.getPainter().getCompositionTextpainter();
        compositionTextPainter.setComposedTextLayout(this.getTextLayout(attributedCharacterIterator, n), n3);
        StringBuffer stringBuffer = new StringBuffer(n2);
        char c = attributedCharacterIterator.setIndex(n);
        for (n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex() - n; c != '\uffff' && n2 > 0; --n2) {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        String string = stringBuffer.toString();
        try {
            if (this.canRemovePreviousInput(n)) {
                this.textArea.getDocument().remove(n3, this.prevComposeString.length());
            }
            this.textArea.getDocument().insertString(n3, string, null);
            if (n > 0) {
                this.initialCaretPosition += n;
            }
            this.prevComposeString = string;
            this.prevCommittedCount = n;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private boolean canRemovePreviousInput(int n) {
        return this.prevCommittedCount == n || this.prevCommittedCount > n;
    }

    public void endCompositionText(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.isInputProcess = false;
        if (n == 0) {
            this.removeNotCommittedText(attributedCharacterIterator);
        }
        CompositionTextPainter compositionTextPainter = this.textArea.getPainter().getCompositionTextpainter();
        compositionTextPainter.invalidateComposedTextLayout(this.initialCaretPosition + n);
        this.prevComposeString = "";
        this.isInputProcess = false;
    }

    private void removeNotCommittedText(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.prevComposeString.length() == 0) {
            return;
        }
        try {
            this.textArea.getDocument().remove(this.initialCaretPosition, this.prevComposeString.length());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private TextLayout getTextLayout(AttributedCharacterIterator attributedCharacterIterator, int n) {
        AttributedString attributedString = new AttributedString(attributedCharacterIterator, n, attributedCharacterIterator.getEndIndex());
        Font font = this.textArea.getPainter().getFont();
        FontRenderContext fontRenderContext = ((Graphics2D)this.textArea.getPainter().getGraphics()).getFontRenderContext();
        attributedString.addAttribute(TextAttribute.FONT, font);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        return textLayout;
    }

    private Point getCaretLocation() {
        Point point = new Point();
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        FontMetrics fontMetrics = textAreaPainter.getFontMetrics();
        int n = fontMetrics.getHeight() - 5;
        int n2 = this.textArea.getCaretLine();
        point.y = n2 * fontMetrics.getHeight() + n;
        int n3 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(n2);
        point.x = this.textArea.offsetToX(n2, n3);
        return point;
    }

    public Rectangle getTextLocation() {
        Point point = this.getCaretLocation();
        return this.getCaretRectangle(point.x, point.y);
    }

    private Rectangle getCaretRectangle(int n, int n2) {
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        Point point = textAreaPainter.getLocationOnScreen();
        int n3 = textAreaPainter.getFontMetrics().getHeight();
        return new Rectangle(point.x + n, point.y + n2, 0, n3);
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2) {
        int n3 = n2 - n;
        String string = this.textArea.getText(n, n3);
        return new AttributedString(string).getIterator();
    }

    public int getInsertPositionOffset() {
        return this.textArea.getCaretPosition() * -1;
    }
}

