/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.im.CompositionTextManager;

public class InputMethodSupport
implements InputMethodRequests,
InputMethodListener {
    private int committed_count = 0;
    private CompositionTextManager textManager;

    public InputMethodSupport(JEditTextArea jEditTextArea) {
        this.textManager = new CompositionTextManager(jEditTextArea);
        jEditTextArea.enableInputMethods(true);
        jEditTextArea.addInputMethodListener(this);
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        return this.textManager.getTextLocation();
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        return null;
    }

    public int getInsertPositionOffset() {
        return this.textManager.getInsertPositionOffset();
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.textManager.getCommittedText(n, n2);
    }

    public int getCommittedTextLength() {
        return this.committed_count;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        this.committed_count = inputMethodEvent.getCommittedCharacterCount();
        if (this.isBeginInputProcess(attributedCharacterIterator, this.textManager)) {
            this.textManager.beginCompositionText(attributedCharacterIterator, this.committed_count);
            this.caretPositionChanged(inputMethodEvent);
            return;
        }
        if (this.isInputProcess(attributedCharacterIterator)) {
            this.textManager.processCompositionText(attributedCharacterIterator, this.committed_count);
            this.caretPositionChanged(inputMethodEvent);
            return;
        }
        this.textManager.endCompositionText(attributedCharacterIterator, this.committed_count);
        this.caretPositionChanged(inputMethodEvent);
    }

    private boolean isBeginInputProcess(AttributedCharacterIterator attributedCharacterIterator, CompositionTextManager compositionTextManager) {
        if (attributedCharacterIterator == null) {
            return false;
        }
        return this.isInputProcess(attributedCharacterIterator) && !compositionTextManager.getIsInputProcess();
    }

    private boolean isInputProcess(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator == null) {
            return false;
        }
        return attributedCharacterIterator.getEndIndex() - (attributedCharacterIterator.getBeginIndex() + this.committed_count) > 0;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        inputMethodEvent.consume();
    }
}

