/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import com.sun.jna.ptr.IntByReference;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import processing.app.windows.Advapi32;
import processing.app.windows.WINBASE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final HashMap<REGISTRY_ROOT_KEY, Integer> rootKeyMap = new HashMap();

    public static void main(String[] stringArray) throws Exception {
    }

    private static int getRegistryRootKey(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY) {
        int n = 0;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference intByReference = new IntByReference();
        if (advapi32.RegOpenKeyEx(rootKeyMap.get((Object)rEGISTRY_ROOT_KEY), null, 0, 0, intByReference) == 0) {
            n = intByReference.getValue();
        }
        return n;
    }

    private static int openKey(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, int n) {
        IntByReference intByReference;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        int n2 = Registry.getRegistryRootKey(rEGISTRY_ROOT_KEY);
        if (advapi32.RegOpenKeyEx(n2, string, 0, n, intByReference = new IntByReference()) == 0) {
            return intByReference.getValue();
        }
        return 0;
    }

    private static String convertBufferToString(byte[] byArray) throws UnsupportedEncodingException {
        return new String(byArray, 0, byArray.length - 2, "UTF-16LE");
    }

    private static int convertBufferToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
    }

    public static String getStringValue(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = new byte[1];
        int n = 0;
        String string3 = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        if (n != 0) {
            if (advapi32.RegQueryValueEx(n, string2, null, intByReference, byArray, intByReference2) == 234 && advapi32.RegQueryValueEx(n, string2, null, intByReference, byArray = new byte[intByReference2.getValue()], intByReference2) == 0) {
                string3 = Registry.convertBufferToString(byArray);
            }
            advapi32.RegCloseKey(n);
        }
        return string3;
    }

    public static int getIntValue(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) {
        byte[] byArray = new byte[1];
        int n = 0;
        int n2 = 0;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        if (n != 0) {
            if (advapi32.RegQueryValueEx(n, string2, null, intByReference, byArray, intByReference2) == 234 && advapi32.RegQueryValueEx(n, string2, null, intByReference, byArray = new byte[intByReference2.getValue()], intByReference2) == 0) {
                n2 = Registry.convertBufferToInt(byArray);
            }
            advapi32.RegCloseKey(n);
        }
        return n2;
    }

    public static boolean deleteValue(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) {
        boolean bl = true;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        int n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131103);
        if (n != 0) {
            if (advapi32.RegDeleteValue(n, string2) == 0) {
                bl = true;
            }
            advapi32.RegCloseKey(n);
        }
        return bl;
    }

    public static boolean setStringValue(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2, String string3) throws UnsupportedEncodingException {
        boolean bl = false;
        byte[] byArray = new byte[string3.length() * 2 + 2];
        byte[] byArray2 = string3.getBytes("UTF-16LE");
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        Advapi32 advapi32 = Advapi32.INSTANCE;
        int n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131103);
        if (n != 0) {
            if (advapi32.RegSetValueEx(n, string2, 0, 1, byArray, byArray.length) == 0) {
                bl = true;
            }
            advapi32.RegCloseKey(n);
        }
        return bl;
    }

    public static boolean setIntValue(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2, int n) {
        boolean bl = false;
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        Advapi32 advapi32 = Advapi32.INSTANCE;
        int n2 = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131103);
        if (n2 != 0) {
            if (advapi32.RegSetValueEx(n2, string2, 0, 4, byArray, byArray.length) == 0) {
                bl = true;
            }
            advapi32.RegCloseKey(n2);
        }
        return bl;
    }

    public static boolean valueExists(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) {
        byte[] byArray = new byte[1];
        int n = 0;
        boolean bl = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        if (n != 0) {
            bl = advapi32.RegQueryValueEx(n, string2, null, intByReference, byArray, intByReference2) != 2;
            advapi32.RegCloseKey(n);
        }
        return bl;
    }

    public static boolean createKey(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) {
        int n = 0;
        boolean bl = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        if (n != 0) {
            if (advapi32.RegCreateKeyEx(n, string2, 0, null, 0, 131097, null, intByReference, intByReference2) == 0) {
                bl = true;
                advapi32.RegCloseKey(intByReference.getValue());
            } else {
                bl = false;
            }
            advapi32.RegCloseKey(n);
        }
        return bl;
    }

    public static boolean deleteKey(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string, String string2) {
        int n = 0;
        boolean bl = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        if (n != 0) {
            bl = advapi32.RegDeleteKey(n, string2) == 0;
            advapi32.RegCloseKey(n);
        }
        return bl;
    }

    public static String[] getSubKeys(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string) {
        int n = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        Advapi32 advapi32 = Advapi32.INSTANCE;
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        char[] cArray = new char[256];
        IntByReference intByReference = new IntByReference(256);
        WINBASE.FILETIME fILETIME = new WINBASE.FILETIME();
        if (n != 0) {
            int n2 = 0;
            while (advapi32.RegEnumKeyEx(n, n2, cArray, intByReference, null, null, null, fILETIME) == 0) {
                treeSet.add(new String(cArray, 0, intByReference.getValue()));
                intByReference.setValue(256);
                ++n2;
            }
            advapi32.RegCloseKey(n);
        }
        return treeSet.toArray(new String[0]);
    }

    public static TreeMap<String, Object> getValues(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string) throws UnsupportedEncodingException {
        int n = 0;
        int n2 = 0;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Advapi32 advapi32 = Advapi32.INSTANCE;
        n = Registry.openKey(rEGISTRY_ROOT_KEY, string, 131097);
        char[] cArray = new char[16384];
        IntByReference intByReference = new IntByReference(16384);
        IntByReference intByReference2 = new IntByReference();
        byte[] byArray = new byte[1];
        IntByReference intByReference3 = new IntByReference();
        if (n != 0) {
            int n3 = 0;
            do {
                intByReference3.setValue(0);
                n2 = advapi32.RegEnumValue(n, n3, cArray, intByReference, null, intByReference2, byArray, intByReference3);
                if (n2 == 234 && (n2 = advapi32.RegEnumValue(n, n3, cArray, intByReference = new IntByReference(16384), null, intByReference2, byArray = new byte[intByReference3.getValue()], intByReference3)) == 0) {
                    String string2 = new String(cArray, 0, intByReference.getValue());
                    switch (intByReference2.getValue()) {
                        case 1: {
                            treeMap.put(string2, Registry.convertBufferToString(byArray));
                            break;
                        }
                        case 4: {
                            treeMap.put(string2, Registry.convertBufferToInt(byArray));
                            break;
                        }
                    }
                }
                ++n3;
            } while (n2 == 0);
            advapi32.RegCloseKey(n);
        }
        return treeMap;
    }

    static {
        rootKeyMap.put(REGISTRY_ROOT_KEY.CLASSES_ROOT, Integer.MIN_VALUE);
        rootKeyMap.put(REGISTRY_ROOT_KEY.CURRENT_USER, -2147483647);
        rootKeyMap.put(REGISTRY_ROOT_KEY.LOCAL_MACHINE, -2147483646);
        rootKeyMap.put(REGISTRY_ROOT_KEY.USERS, -2147483645);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum REGISTRY_ROOT_KEY {
        CLASSES_ROOT,
        CURRENT_USER,
        LOCAL_MACHINE,
        USERS;

    }
}

