#   Copyright (c) 2013 Daniel Thiele, Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.
#
"""Check if xmpl_hif_<board>.hex works as expected"""

import serial, time, os, sys
import programming as prg
from utilities import *

VERSION = "0.1"
CFGDATA = {}
PROG_NAME = os.path.basename(sys.argv[0])

if __name__ == '__main__':

    CFGDATA = test_init(__doc__, VERSION)
    if not CFGDATA:
        sys.exit(1)

    prg.announce_config(CFGDATA)
    duts = CFGDATA.get(PROG_NAME, "duts").split()
    print "* duts", duts

    # === flash nodes ==========================================================
    ser = {}
    info = {}
    for dut in duts:
        prog_template = "%s/xmpl_hif_%%s.hex" % CFGDATA.get("CONFIG", "bin_dir")

        # prepare port for later operation
        s = serial.Serial(port = CFGDATA.get(dut,"port"),
                          baudrate = CFGDATA.get(dut,"baudrate"),
                          timeout = 3.0)
        s.close()
        ser[dut] = s
        info[dut] = dict(CFGDATA.items(dut))

        # flash firmware
        prg.load_firmware(dut,
                          CFGDATA.get("CONFIG", "bin_dir") + "/xmpl_hif_%s.hex",
                          CFGDATA.getint("CONFIG", "force_flash")
                          )

    # === start test ===========================================================
    for dut in duts:
        print "DUT: %(boardname)s@%(port)s" % info[dut]
        s = ser[dut]
        s.open()
        opentmo = float(info[dut].get("opentmo", "0"))
        time.sleep(opentmo)
        ser_get_text(s,200)

        print "test echo",
        pattern = 'hi there'
        s.write(pattern)
        s.flush()
        rx_pattern = ser_get_text(s,20)
        if test_error(pattern == rx_pattern, "data error"):
            print "TX:",pattern
            print "RX:",rx_pattern

        print "test newline",
        s.write("\n")
        s.flush()
        rx_pattern = ser_get_text(s,20)
        if test_error(rx_pattern.find("uracoli[")> -1, "data error"):
            print "TX:",pattern
            print "RX:",rx_pattern

        s.close()

    print "pass"
    sys.exit(0)
#EOF
