#   Copyright (c) 2010 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id$

# === main parameters of the project =========================================

URACOLIDIR = ..
OBJDIR=obj
LIBDIR=$(URACOLIDIR)/lib
TARGETS=$(OBJDIR) $(LIBDIR) __liburacoli__
# DBGFMT=stabs for Linux
# DBGFMT=dwarf-2 for Windows

CCFLAGS=-c -Wall -Wundef -Os -g$(DBGFMT) -mmcu=$(MCU) -D$(BOARD)
CCFLAGS+=-DF_CPU=$(F_CPU)
CCFLAGS+=-I$(URACOLIDIR)/inc -I.

# === custom settings ======================================================
%(more_flags)s

CC=avr-gcc
AR=avr-ar
RANLIB=avr-ranlib

# guessing the OS for a working (g)mkdir
ifdef SystemRoot
    MKDIR=gmkdir -p
else
    MKDIR=mkdir -p
endif

# === autogenerated board rules ========================================
help:
	@echo
	@echo "========================================================="
	@echo "Enter a board name or "all" for building the libraries.  "
	@echo "Have a look in the docu for what board you want to build."
	@echo "========================================================="
	@echo

%(all_rule)s

%(board_rules)s

clean:
	rm -rf $(OBJDIR)/*.o

# === internal rules ===================================================

# temporary output directory
$(OBJDIR):
	$(MKDIR) $@

$(LIBDIR):
	$(MKDIR) $@

# radio library
RADIOSRC=$(wildcard libradio/*.c)
RADIOOBJ=$(addprefix $(OBJDIR)/, $(patsubst %%.c, $(BOARD)_%%.o, $(notdir $(RADIOSRC))))
RADIOLIB=$(LIBDIR)/libradio_$(BOARD).a


$(OBJDIR)/$(BOARD)_%%.o : libradio/%%.c ;
	$(CC)  -fno-inline $(CCFLAGS) -o $@ -c $<


# ioutil library
IOUTILSRC=$(wildcard libioutil/*.c)
IOUTILOBJ=$(addprefix $(OBJDIR)/, $(patsubst %%.c, $(BOARD)_%%.o, $(notdir $(IOUTILSRC))))
IOUTILLIB=$(LIBDIR)/libio_$(BOARD).a

$(OBJDIR)/$(BOARD)_%%.o : libioutil/%%.c ;
	$(CC) $(CCFLAGS) -o $@ -c $<

# uracoli all in one library
URACOLILIB=$(LIBDIR)/liburacoli_$(BOARD).a

__liburacoli__: $(URACOLILIB)

$(URACOLILIB): $(RADIOOBJ) $(IOUTILOBJ)
	$(AR) rc $@ $?
	$(RANLIB) $@
