#   Copyright (c) 2011 - 2014 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id$

# === main parameters of the project =========================================
TOPDIR = ..
PROJECT = xmpl_tsl2550
CURRENT_MAKEFILE = xmpl_tsl2550.mk
BOARD = UNDEFINED
PART = UNDEFINED
APPNAME = "\"xmpl_tsl2550\""

OBJDIR = $(TOPDIR)/build
BINDIR = $(TOPDIR)/bin
LIBDIR = $(TOPDIR)/lib

# guessing the OS for a working (g)mkdir
ifndef MKDIR
    ifdef SystemRoot
        MKDIR=gmkdir -p
    else
        MKDIR=mkdir -p
    endif
endif

# === autogenerated board rules ========================================
help:
	@echo
	@echo "========================================================="
	@echo "Enter a board name or "all" for building the libraries.  "
	@echo "Have a look in the docu for what board you want to build."
	@echo "========================================================="
	@echo

all: mnb900 wdba1281

list:
	 @echo '  mnb900           : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'
	 @echo '  wdba1281         : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'


mnb900:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=mnb900 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

wdba1281:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=wdba1281 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)


clean:
	rm -rf $(OBJDIR)/*.o $(OBJDIR)/*.lst $(BINDIR)/*.elf $(BINDIR)/*.hex

# === internal rules ===================================================

# temporary output directory
$(OBJDIR):
	$(MKDIR) $@

$(BINDIR):
	$(MKDIR) $@

TARGETS=$(OBJDIR) $(BINDIR) __xmpl_tsl2550__
SOURCES = xmpl_tsl2550.c
INCDIRS = . $(TOPDIR)/inc
LIBDIRS = $(TOPDIR)/lib
# DBGFMT=stabs for Linux
# DBGFMT=dwarf-2 for Windows
DBGFMT=
# automatically derived parameters
OBJECTS = $(SOURCES:%.c=$(OBJDIR)/%_$(BOARD).o)
TARGET = $(BINDIR)/$(PROJECT)_$(BOARD)

# === tool parameters ======================================================

CCFLAGS = -Wall -Wundef -Os -g$(DBGFMT) -ffunction-sections -fdata-sections -std=c99 -mmcu=$(MCU)
CCFLAGS += -Wa,-adhlns=$(<:%.c=$(OBJDIR)/%_$(BOARD).lst)
CCFLAGS += -D$(BOARD)
CCFLAGS += -DF_CPU=$(F_CPU)
CCFLAGS += -DAPP_NAME=$(APPNAME)
ifneq ($(baudrate),)
  CCFLAGS += -DHIF_DEFAULT_BAUDRATE=$(baudrate)
endif
CCFLAGS += -I$(TOPDIR)/inc -I.
LDFLAGS = $(patsubst %,-L%,$(LIBDIRS)) -Wl,--gc-sections -luracoli_$(BOARD)
OCFLAGS=-O ihex

# === custom settings ======================================================
# --- todo ---


# hier koennte ihre toolchain stehen!
ifeq ($(TC), AVR8)
   CC=avr-gcc
   AR=avr-ar
   RANLIB=avr-ranlib
   OBJCOPY=avr-objcopy
else ifeq ($(TC), ARM)
   CC=arm-none-eabi-gcc
   AR=arm-none-eabi-ar
   RANLIB=arm-none-eabi-ranlib
   OBJCOPY=arm-none-eabi-objcopy
else 
   CC=@echo undefined cc for $(TC)
   AR=@echo undefined ar for $(TC)
   RANLIB=@echo undefined ranlib for $(TC)
   OBJCOPY=@echo undefined objcopy for $(TC)
endif


# === build rules ============================================================

__xmpl_tsl2550__: $(TARGET).hex

$(TARGET).hex: $(TARGET).elf
	$(OBJCOPY) $(OCFLAGS) $< $@

$(TARGET).elf: $(OBJECTS) $(LIBDIRS)/liburacoli_$(BOARD).a
	$(CC) -o $@ $(CCFLAGS) $(OBJECTS) $(LDFLAGS)

$(OBJDIR)/%_$(BOARD).o: %.c
	$(CC) $(CCFLAGS) -c -o $@ $<

$(LIBDIRS)/liburacoli_$(BOARD).a:
	cd $(TOPDIR)/uracoli && make $(BOARD)
