<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   pictures.php - Photo gallery main creation file */

// Load the main headers for ThemeX, which will (in turn) load the configuration for our selected theme
if(!file_exists('westgen/index.php')) {
	die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your installation may be corrupt.'); }
define("westgen", true);
include("westgen/index.php");

// See if user provides selection, else set default
if($_SERVER['PATH_INFO'] == '') {
	$selected_file = 'pictures/';
} else {
	$selected_file = 'pictures' . $_SERVER['PATH_INFO'];
}

// Make sure gallery directory is real
if(!is_dir($selected_file)) {
	die('<b>Fatal error:</b> ' . $wg_identify . ' could not find the path to the requested gallery, permission was denied, or is not a valid directory (<i>' . $_SERVER['PATH_INFO'] . '</i>).');
} else {
	if(file_exists($selected_file . '/.title')) {
		$page_title = $theme_gallery_prefix . stripslashes(file_get_contents($selected_file . "/.title"));
	} else {
		$page_title = $theme_gallery_prefix . "(no title)";
	} // End title check
} // End dir check

// Decide on Page Layout mode
if($_GET['page_layout'] != '') {
	// DEBUG Enables forcing of layout by browser
    $page_layout = $_GET['page_layout'];
} else {
	// The default page layout for a gallery
    $page_layout = 'gallery';
}

// Check to see if we can use the selected layout
if(!is_dir($theme_root . '/' . $page_layout)) {
	die('<b>Fatal error:</b> ' . $wg_identify . ' could not load the selected layout files (<i>' . $page_layout . '</i>)');
} else {
	// Write out the page with selected layout
	include($theme_root . '/' . $page_layout . '/index.php');
}

?>
