/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.core;

import java.io.FileNotFoundException;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestObjectRoot;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EmptyXmlTest
extends TestCase {
    public void testFileNotFound() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        try {
            reader.readFile("tests/empty-xml/non-excisting-file.xml");
        }
        catch (FileNotFoundException e) {
            EmptyXmlTest.assertEquals((boolean)true, (boolean)e.getMessage().contains("non-excisting-file.xml"));
            return;
        }
        EmptyXmlTest.assertEquals((boolean)true, (boolean)false);
    }

    public void testResourceNotFound() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        try {
            reader.readResource("tests/empty-xml/non-excisting-resource.xml");
        }
        catch (NullPointerException e) {
            EmptyXmlTest.assertEquals((boolean)true, (boolean)e.getMessage().contains("Could not find resource"));
            return;
        }
        EmptyXmlTest.assertEquals((boolean)true, (boolean)false);
    }

    public void testResourceParsing() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        try {
            reader.readResource("tests/empty-xml/empty-test.xml");
        }
        catch (SAXParseException e) {
            EmptyXmlTest.assertEquals((String)"No ElementNamespaceContext found for empty namespace.", (String)e.getMessage());
            return;
        }
        EmptyXmlTest.assertEquals((boolean)true, (boolean)false);
    }

    public void testResourceEmptyReal() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        try {
            reader.readResource("tests/empty-xml/empty-real.xml");
        }
        catch (SAXException e) {
            EmptyXmlTest.assertEquals((boolean)true, (boolean)e.getMessage().contains("Premature end of file."));
            return;
        }
        EmptyXmlTest.assertEquals((boolean)true, (boolean)false);
    }

    public void testResourceEmptyXml() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        try {
            reader.readResource("tests/empty-xml/empty-xml.xml");
        }
        catch (SAXException e) {
            boolean hasError = e.getMessage().contains("Premature end of file.");
            if (!hasError) {
                hasError = e.getMessage().contains("A well-formed document requires a root element.");
            }
            EmptyXmlTest.assertEquals((boolean)true, (boolean)hasError);
            return;
        }
        EmptyXmlTest.assertEquals((boolean)true, (boolean)false);
    }

    public void testEmptyX40() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        EmptyXmlTest.assertNotNull((Object)((Object)driver));
        X4OReader reader = driver.createReader();
        EmptyXmlTest.assertNotNull((Object)reader);
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/empty-xml/empty-x4o.xml");
        EmptyXmlTest.assertNotNull((Object)root);
        EmptyXmlTest.assertEquals((boolean)true, (boolean)root.getTestBeans().isEmpty());
        EmptyXmlTest.assertEquals((boolean)true, (boolean)root.getTestObjectChilds().isEmpty());
        EmptyXmlTest.assertEquals((boolean)true, (boolean)root.getTestObjectParents().isEmpty());
        EmptyXmlTest.assertEquals((boolean)true, (boolean)root.getTestObjects().isEmpty());
    }
}

