/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.x4o.xml.element.AbstractElement;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.lang.X4OLanguageClassLoader;

public class BeanElement
extends AbstractElement {
    private List<Object> constructorArguments = new ArrayList<Object>(3);

    public void doElementStart() throws ElementException {
        String className = this.getAttributes().get("bean.class");
        if ("".equals(className) | className == null) {
            throw new ElementException("Set the bean.class attribute");
        }
        try {
            Class<?> beanClass = X4OLanguageClassLoader.loadClass(className);
            if (this.constructorArguments.isEmpty()) {
                this.setElementObject(beanClass.newInstance());
            } else {
                Class[] arguClass = new Class[this.constructorArguments.size()];
                this.constructorArguments.toArray(arguClass);
                Constructor<?> c = beanClass.getConstructor(arguClass);
                this.setElementObject(c.newInstance(this.constructorArguments));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ElementException(e);
        }
        catch (InstantiationException e) {
            throw new ElementException(e);
        }
        catch (IllegalAccessException e) {
            throw new ElementException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ElementException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ElementException(e);
        }
        catch (InvocationTargetException e) {
            throw new ElementException(e);
        }
    }

    public void addConstuctorArgument(Object argu) {
        if (argu == null) {
            throw new NullPointerException("Can't add null argument for constructor.");
        }
        this.constructorArguments.add(argu);
    }
}

