/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.lang;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.x4o.xml.element.AbstractElementBindingHandler;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementBindingHandlerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementRefectionBindingHandler
extends AbstractElementBindingHandler<Object> {
    private Class<?> parentClass = null;
    private Class<?> childClass = null;
    private String addMethod = null;
    private String getMethod = null;
    private String skipChilderenClassRegex = null;

    @Override
    public Class<?> getBindParentClass() {
        return this.parentClass;
    }

    @Override
    public Class<?>[] getBindChildClasses() {
        return new Class[]{this.childClass};
    }

    @Override
    public void bindChild(Element childElement, Object parentObject, Object childObject) throws ElementBindingHandlerException {
        Method[] ms;
        if (this.parentClass == null | this.childClass == null | this.addMethod == null) {
            throw new IllegalStateException("Missing property: parentClass=" + this.parentClass + " childClass=" + this.childClass + " addMethod=" + this.addMethod + ".");
        }
        for (Method m : ms = parentObject.getClass().getMethods()) {
            Class<?>[] types = m.getParameterTypes();
            if (types.length == 0 || types.length > 1 || !this.addMethod.equalsIgnoreCase(m.getName()) || !types[0].isAssignableFrom(this.childClass)) continue;
            try {
                m.invoke(parentObject, childObject);
            }
            catch (Exception e) {
                throw new ElementBindingHandlerException("Error invoke binding method of: " + this.getId() + " error: " + e.getMessage(), e);
            }
            return;
        }
        throw new ElementBindingHandlerException("Could not find method: " + this.addMethod + " on: " + this.childClass + " id:" + this.getId());
    }

    @Override
    public void createChilderen(Element parentElement, Object parentObject) throws ElementBindingHandlerException {
        Method[] ms;
        if (this.parentClass == null | this.childClass == null | this.getMethod == null) {
            throw new IllegalStateException("Missing property: parentClass=" + this.parentClass + " childClass=" + this.childClass + " getMethod=" + this.getMethod + ".");
        }
        for (Method m : ms = parentObject.getClass().getMethods()) {
            Object result;
            Class<?>[] types = m.getParameterTypes();
            if (types.length != 0 || !this.getMethod.equalsIgnoreCase(m.getName())) continue;
            try {
                result = m.invoke(parentObject, new Object[0]);
            }
            catch (Exception e) {
                throw new ElementBindingHandlerException("Invoke error: " + e.getMessage() + " from: " + this.getMethod + " on: " + parentObject + " id:" + this.getId(), e);
            }
            if (result == null) break;
            if (result instanceof List) {
                for (Object o : (List)result) {
                    this.createSafeChild(parentElement, o);
                }
                return;
            }
            if (result instanceof Collection) {
                for (Object o : (Collection)result) {
                    this.createSafeChild(parentElement, o);
                }
                return;
            }
            if (result.getClass().isArray()) {
                for (Object o : (Object[])result) {
                    this.createSafeChild(parentElement, o);
                }
                return;
            }
            if (this.childClass.isAssignableFrom(result.getClass())) {
                this.createSafeChild(parentElement, result);
                return;
            }
            throw new ElementBindingHandlerException("Unsuported return type: " + result.getClass() + " need: " + this.childClass + " from: " + this.getMethod + " on: " + parentObject + " id:" + this.getId());
        }
        throw new ElementBindingHandlerException("Could not find method: " + this.getMethod + " on: " + parentObject + " id:" + this.getId());
    }

    protected void createSafeChild(Element parentElement, Object childObject) {
        if (!this.childClass.isAssignableFrom(childObject.getClass())) {
            return;
        }
        if (this.skipChilderenClassRegex != null && childObject.getClass().getName().matches(this.skipChilderenClassRegex)) {
            return;
        }
        this.createChild(parentElement, childObject);
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    public Class<?> getChildClass() {
        return this.childClass;
    }

    public void setChildClass(Class<?> childClass) {
        this.childClass = childClass;
    }

    public String getAddMethod() {
        return this.addMethod;
    }

    public void setAddMethod(String addMethod) {
        this.addMethod = addMethod;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(String getMethod) {
        this.getMethod = getMethod;
    }

    public String getSkipChilderenClassRegex() {
        return this.skipChilderenClassRegex;
    }

    public void setSkipChilderenClassRegex(String skipChilderenClassRegex) {
        this.skipChilderenClassRegex = skipChilderenClassRegex;
    }
}

