/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProvider;
import org.x4o.xml.io.sax.ext.AttributeMap;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class X4OContentHandler
extends DefaultHandler2 {
    private Logger logger = Logger.getLogger(X4OContentHandler.class.getName());
    private boolean loggerFinest = this.logger.isLoggable(Level.FINEST);
    private Locator locator = null;
    private Stack<Element> elementStack = new Stack();
    private X4OLanguageContext elementLanguage = null;
    private Element overrideSaxElement = null;
    private DefaultHandler2 overrideSaxHandler = null;

    public X4OContentHandler(X4OLanguageContext elementLanguage) {
        this.elementLanguage = elementLanguage;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String prefix, String namespaceUri) throws SAXException {
        if (this.overrideSaxHandler != null) {
            this.overrideSaxHandler.startPrefixMapping(prefix, namespaceUri);
            return;
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri)) {
            return;
        }
        if ("http://www.w3.org/2001/XInclude".equals(namespaceUri)) {
            return;
        }
        ElementNamespaceContext enc = this.elementLanguage.getLanguage().findElementNamespaceContext(namespaceUri);
        if (enc == null) {
            throw new SAXException("Can't find namespace uri: " + namespaceUri + " in language: " + this.elementLanguage.getLanguage().getLanguageName());
        }
        enc.setPrefixMapping(prefix);
    }

    public void startElement(String namespaceUri, String tag, String qName, Attributes attributes) throws SAXException {
        if (this.loggerFinest) {
            this.logger.finest("XMLTAG-START: " + namespaceUri + ":" + tag);
        }
        if (this.overrideSaxHandler != null) {
            this.overrideSaxHandler.startElement(namespaceUri, tag, qName, attributes);
            return;
        }
        ElementNamespaceContext enc = this.elementLanguage.getLanguage().findElementNamespaceContext(namespaceUri);
        if (enc == null) {
            if ("".equals(namespaceUri)) {
                String configEmptryUri = (String)this.elementLanguage.getLanguageProperty(X4OLanguageProperty.READER_EMPTY_NAMESPACE_URI);
                if (configEmptryUri != null) {
                    namespaceUri = configEmptryUri;
                    enc = this.elementLanguage.getLanguage().findElementNamespaceContext(namespaceUri);
                }
                if (enc == null) {
                    throw new SAXParseException("No ElementNamespaceContext found for empty namespace.", this.locator);
                }
                enc.setPrefixMapping("");
            }
            if (enc == null) {
                throw new SAXParseException("No ElementProvider found for namespace: " + namespaceUri, this.locator);
            }
        }
        ElementNamespaceInstanceProvider eip = enc.getElementNamespaceInstanceProvider();
        Element element = null;
        try {
            element = eip.createElementInstance(this.elementLanguage, tag);
        }
        catch (Exception e) {
            throw new SAXParseException("Error while creating element: " + e.getMessage(), this.locator, e);
        }
        enc.addElementClass(element.getElementClass());
        if (this.elementStack.empty()) {
            this.elementLanguage.setRootElement(element);
        } else {
            Element parent = this.elementStack.peek();
            element.setParent(parent);
            parent.addChild(element);
        }
        AttributeMap map = new AttributeMap(attributes);
        element.getAttributes().putAll(map);
        this.elementStack.push(element);
        try {
            element.doElementStart();
        }
        catch (ElementException ee) {
            throw new SAXParseException("Error while configing element: " + ee.getMessage(), this.locator, ee);
        }
        if (Element.ElementType.overrideSax.equals((Object)element.getElementType())) {
            this.overrideSaxElement = element;
            this.overrideSaxHandler = (DefaultHandler2)element.getElementObject();
        }
    }

    public void endElement(String namespaceUri, String tag, String qName) throws SAXException {
        if (this.loggerFinest) {
            this.logger.finest("XMLTAG-END: " + namespaceUri + ":" + tag);
        }
        if (this.overrideSaxHandler != null) {
            if (this.overrideSaxElement.getElementClass().getId().equals(tag)) {
                this.overrideSaxHandler.endDocument();
                this.overrideSaxHandler = null;
                this.overrideSaxElement = null;
            } else {
                this.overrideSaxHandler.endElement(namespaceUri, tag, qName);
                return;
            }
        }
        if (this.elementStack.empty()) {
            return;
        }
        Element element = this.elementStack.pop();
        try {
            element.doElementEnd();
        }
        catch (ElementException ee) {
            throw new SAXParseException("Error while configing element: '" + tag + "' " + ee.getMessage(), this.locator, ee);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.overrideSaxHandler != null) {
            this.overrideSaxHandler.characters(ch, start, length);
            return;
        }
        if (length == 0) {
            return;
        }
        String text = new String(ch, start, length);
        if (text.length() == 0) {
            return;
        }
        if (this.elementStack.isEmpty()) {
            return;
        }
        Element e = this.elementStack.peek();
        try {
            e.doCharacters(text);
        }
        catch (ElementException ee) {
            throw new SAXParseException("Error while doCharacters element: '" + e.getElementClass().getId() + "' " + ee.getMessage(), this.locator, ee);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.overrideSaxHandler != null) {
            this.overrideSaxHandler.ignorableWhitespace(ch, start, length);
            return;
        }
        String text = new String(ch);
        if ((text = text.substring(start, start + length)).length() == 0) {
            return;
        }
        if (this.elementStack.empty()) {
            return;
        }
        Element e = this.elementStack.peek();
        try {
            e.doIgnorableWhitespace(text);
        }
        catch (ElementException ee) {
            throw new SAXParseException("Error while doIgnorableWhitespace element: '" + e.getElementClass().getId() + "' " + ee.getMessage(), this.locator, ee);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.overrideSaxHandler != null) {
            this.overrideSaxHandler.comment(ch, start, length);
            return;
        }
        String text = new String(ch);
        if ((text = text.substring(start, start + length)).length() == 0) {
            return;
        }
        if (this.elementStack.empty()) {
            return;
        }
        Element e = this.elementStack.peek();
        try {
            e.doComment(text);
        }
        catch (ElementException ee) {
            throw new SAXParseException("Error while doComment element: '" + e.getElementClass().getId() + "' " + ee.getMessage(), this.locator, ee);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.logger.fine("Skipping process instuctions: " + target + " data: " + data);
    }
}

