/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax.ext;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.x4o.xml.io.XMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AbstractContentWriterHandler
implements ContentHandler {
    protected final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    protected String encoding = null;
    private String charNewline = null;
    private String charTab = null;
    private Writer out = null;
    private int indent = 0;
    private Map<String, String> prefixMapping = null;
    private List<String> printedMappings = null;
    private StringBuffer startElement = null;
    private boolean printReturn = false;
    private String lastElement = null;
    private Stack<String> elements = null;

    public AbstractContentWriterHandler(Writer out, String encoding, String charNewLine, String charTab) {
        if (out == null) {
            throw new NullPointerException("Can't write on null writer.");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (charNewLine == null) {
            charNewLine = "\n";
        }
        if (charTab == null) {
            charTab = "\t";
        }
        this.out = out;
        this.encoding = encoding;
        this.charNewline = charNewLine;
        this.charTab = charTab;
        this.prefixMapping = new HashMap<String, String>(15);
        this.printedMappings = new ArrayList<String>(15);
        this.elements = new Stack();
    }

    public void closeWriter() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
    }

    public void closeWriterSafe() {
        try {
            this.closeWriter();
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public void startDocument() throws SAXException {
        this.indent = 0;
        this.write(XMLConstants.getDocumentDeclaration(this.encoding));
    }

    public void endDocument() throws SAXException {
        this.writeFlush();
        if (this.elements.size() > 0) {
            throw new SAXException("Invalid xml still have " + this.elements.size() + " elements open.");
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (localName == null) {
            throw new SAXException("LocalName may not be null.");
        }
        if (!XMLConstants.isNameString(localName)) {
            throw new SAXException("LocalName of element is not valid in xml; '" + localName + "'");
        }
        this.autoCloseStartElement();
        this.startElement = new StringBuffer(200);
        this.startElement.append(this.charNewline);
        for (int i = 0; i < this.indent; ++i) {
            this.startElement.append(this.charTab);
        }
        this.startElement.append("<");
        this.startElementTag(uri, localName);
        this.startElementNamespace(uri);
        this.startElementAttributes(atts);
        this.startElement.append(">");
        ++this.indent;
        this.lastElement = localName;
        this.elements.push(localName);
    }

    public void startElementTag(String uri, String localName) throws SAXException {
        if ("".equals(uri) | uri == null) {
            this.startElement.append(localName);
        } else {
            String prefix = this.prefixMapping.get(uri);
            if (prefix == null) {
                throw new SAXException("preFixUri: " + uri + " is not started.");
            }
            if (!"".equals(prefix)) {
                this.startElement.append(prefix);
                this.startElement.append(":");
            }
            this.startElement.append(localName);
        }
    }

    public void startElementNamespace(String uri) throws SAXException {
        if (uri != null & !"".equals(uri) && !this.printedMappings.contains(uri)) {
            String prefix = this.prefixMapping.get(uri);
            if (prefix == null) {
                throw new SAXException("preFixUri: " + uri + " is not started.");
            }
            this.printedMappings.add(uri);
            this.startElement.append(' ');
            this.startElement.append("xmlns");
            if (!"".equals(prefix)) {
                this.startElement.append(':');
                this.startElement.append(prefix);
            }
            this.startElement.append("=\"");
            this.startElement.append(uri);
            this.startElement.append('\"');
            this.startElementNamespaceAll(uri);
        }
    }

    public void startElementNamespaceAll(String uri) throws SAXException {
        String prefix = null;
        boolean first = true;
        for (String uri2 : this.prefixMapping.keySet()) {
            if (this.printedMappings.contains(uri2)) continue;
            prefix = this.prefixMapping.get(uri2);
            if (prefix == null) {
                throw new SAXException("preFixUri: " + uri + " is not started.");
            }
            this.printedMappings.add(uri2);
            if (first) {
                this.startElement.append(this.charNewline);
                first = false;
            }
            this.startElement.append(' ');
            this.startElement.append("xmlns");
            if (!"".equals(prefix)) {
                this.startElement.append(":");
                this.startElement.append(prefix);
            }
            this.startElement.append("=\"");
            this.startElement.append(uri2);
            this.startElement.append('\"');
            this.startElement.append(this.charNewline);
        }
    }

    private void startElementAttributes(Attributes atts) throws SAXException {
        for (int i = 0; i < atts.getLength(); ++i) {
            boolean printNewLine;
            String attributeUri = atts.getURI(i);
            String attributeName = XMLConstants.escapeAttributeName(atts.getLocalName(i));
            String attributeValue = atts.getValue(i);
            if (attributeValue == null) {
                attributeValue = "null";
            }
            String attributeValueSafe = XMLConstants.escapeAttributeValue(attributeValue);
            this.startElement.append(' ');
            if ("".equals(attributeUri) | attributeUri == null) {
                this.startElement.append(attributeName);
            } else {
                this.startElement.append(attributeUri);
                this.startElement.append(":");
                this.startElement.append(attributeName);
            }
            this.startElement.append("=\"");
            this.startElement.append(attributeValueSafe);
            this.startElement.append('\"');
            boolean bl = printNewLine = attributeValueSafe.length() > 80;
            if (!printNewLine) continue;
            this.startElement.append('\n');
            for (int ii = 0; ii < this.indent + 1; ++ii) {
                this.startElement.append(this.charTab);
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.elements.size() > 0 && !this.elements.peek().equals(localName)) {
            throw new SAXException("Unexpected end tag: " + localName + " should be: " + this.elements.peek());
        }
        this.elements.pop();
        if (this.startElement != null) {
            String tag = this.startElement.toString();
            this.write(tag.substring(0, tag.length() - 1));
            this.write("/>");
            this.startElement = null;
            --this.indent;
            return;
        }
        --this.indent;
        if (this.printReturn || !localName.equals(this.lastElement)) {
            this.write(this.charNewline);
            this.writeIndent();
        } else {
            this.printReturn = true;
        }
        if (localName == null) {
            localName = "null";
        }
        this.write("</");
        if ("".equals(uri) | uri == null) {
            this.write(localName);
        } else {
            String prefix = this.prefixMapping.get(uri);
            if (prefix == null) {
                throw new SAXException("preFixUri: " + uri + " is not started.");
            }
            if (!"".equals(prefix)) {
                this.write(prefix);
                this.write(":");
            }
            this.write(localName);
        }
        this.write(">");
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMapping.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Set<Map.Entry<String, String>> s = this.prefixMapping.entrySet();
        String uri = null;
        for (Map.Entry<String, String> e : s) {
            if (e.getValue() == null || !e.getValue().equals(prefix)) continue;
            uri = e.getKey();
        }
        if (uri != null) {
            this.printedMappings.remove(uri);
            this.prefixMapping.remove(uri);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters(new String(ch, start, length));
    }

    public void characters(String text) throws SAXException {
        if (text == null) {
            return;
        }
        this.charactersRaw(XMLConstants.escapeCharacters(text));
    }

    public void characters(char c) throws SAXException {
        this.characters(new char[]{c}, 0, 1);
    }

    public void charactersRaw(String text) throws SAXException {
        if (text == null) {
            return;
        }
        this.autoCloseStartElement();
        this.checkPrintedReturn(text);
        this.write(text);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.ignorableWhitespace(new String(ch, start, length));
    }

    public void ignorableWhitespace(String text) throws SAXException {
        if (text == null) {
            return;
        }
        this.autoCloseStartElement();
        this.write(text);
    }

    public void ignorableWhitespace(char c) throws SAXException {
        this.ignorableWhitespace(new char[]{c}, 0, 1);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        String targetLow = target.toLowerCase();
        if (targetLow.startsWith("xml")) {
            throw new SAXException("Processing instruction may not start with xml.");
        }
        if (!XMLConstants.isNameString(target)) {
            throw new SAXException("Processing instruction target is invalid name; '" + target + "'");
        }
        if (!XMLConstants.isCharString(data)) {
            throw new SAXException("Processing instruction data is invalid char; '" + data + "'");
        }
        this.autoCloseStartElement();
        this.write(this.charNewline);
        this.writeIndent();
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        this.writeFlush();
        this.printReturn = true;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.comment(new String(ch, start, length));
    }

    public void comment(String text) throws SAXException {
        if (text == null) {
            return;
        }
        this.autoCloseStartElement();
        this.checkPrintedReturn(text);
        this.write(this.charNewline);
        this.writeIndent();
        this.write("<!--");
        this.write(" ");
        this.write(XMLConstants.escapeCharactersComment(text, this.charTab, this.indent));
        this.write(" ");
        this.write("-->");
        this.printReturn = true;
    }

    private void checkPrintedReturn(String value) {
        this.printReturn = value.indexOf(10) > 0;
    }

    protected void autoCloseStartElement() throws SAXException {
        if (this.startElement == null) {
            return;
        }
        this.write(this.startElement.toString());
        this.startElement = null;
    }

    private void writeIndent() throws SAXException {
        for (int i = 0; i < this.indent; ++i) {
            this.write(this.charTab);
        }
    }

    protected void writeFlush() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(String text) throws SAXException {
        try {
            this.out.write(text);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(char c) throws SAXException {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

