/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.el.X4OExpressionFactory;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeValueParser;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProviderException;
import org.x4o.xml.element.ElementObjectPropertyValue;
import org.x4o.xml.lang.DefaultX4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageConfiguration;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageContextLocal;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultX4OLanguage
implements X4OLanguageLocal {
    private Logger logger = null;
    private X4OLanguageConfiguration languageConfiguration = null;
    private List<X4OLanguageModule> elementLanguageModules = null;
    private String languageName = null;
    private String languageVersion = null;
    private X4OPhaseManager phaseManager = null;

    public DefaultX4OLanguage(X4OLanguageConfiguration languageConfiguration, X4OPhaseManager phaseManager, String languageName, String languageVersion) {
        if (languageName == null) {
            throw new NullPointerException("Can't define myself with null name.");
        }
        if (languageVersion == null) {
            throw new NullPointerException("Can't define myself with null version.");
        }
        this.logger = Logger.getLogger(DefaultX4OLanguage.class.getName());
        this.elementLanguageModules = new ArrayList<X4OLanguageModule>(20);
        this.languageConfiguration = languageConfiguration;
        this.languageName = languageName;
        this.languageVersion = languageVersion;
        this.phaseManager = phaseManager;
    }

    @Override
    public String getLanguageName() {
        return this.languageName;
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public X4OPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Override
    public X4OLanguageConfiguration getLanguageConfiguration() {
        return this.languageConfiguration;
    }

    @Override
    public void addLanguageModule(X4OLanguageModule elementLanguageModule) {
        if (elementLanguageModule.getId() == null) {
            throw new NullPointerException("Can't add module without id.");
        }
        this.elementLanguageModules.add(elementLanguageModule);
    }

    @Override
    public List<X4OLanguageModule> getLanguageModules() {
        return this.elementLanguageModules;
    }

    @Override
    public X4OLanguageContext createLanguageContext(X4ODriver<?> driver) {
        X4OLanguageContext result = this.buildElementLanguage(new DefaultX4OLanguageContext(this), driver);
        try {
            this.getPhaseManager().runPhases(result, X4OPhaseType.INIT);
        }
        catch (X4OPhaseException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected X4OLanguageContext buildElementLanguage(X4OLanguageContext languageContext, X4ODriver<?> driver) {
        if (!(languageContext instanceof X4OLanguageContextLocal)) {
            throw new RuntimeException("Can't init X4OLanguageContext which has not X4OLanguageContextLocal interface obj: " + languageContext);
        }
        X4OLanguageContextLocal contextInit = (X4OLanguageContextLocal)languageContext;
        for (String key : languageContext.getLanguage().getLanguageConfiguration().getGlobalPropertyKeys()) {
            Object value = languageContext.getLanguage().getLanguageConfiguration().getGlobalProperty(key);
            contextInit.setLanguageProperty(key, value);
        }
        try {
            if (contextInit.getExpressionLanguageFactory() == null) {
                contextInit.setExpressionLanguageFactory(X4OExpressionFactory.createExpressionFactory(contextInit));
            }
            if (contextInit.getExpressionLanguageContext() == null) {
                contextInit.setExpressionLanguageContext(X4OExpressionFactory.createELContext(contextInit));
            }
            if (contextInit.getElementAttributeValueParser() == null) {
                contextInit.setElementAttributeValueParser((ElementAttributeValueParser)X4OLanguageClassLoader.newInstance(this.getLanguageConfiguration().getDefaultElementAttributeValueParser()));
            }
            if (contextInit.getElementObjectPropertyValue() == null) {
                contextInit.setElementObjectPropertyValue((ElementObjectPropertyValue)X4OLanguageClassLoader.newInstance(this.getLanguageConfiguration().getDefaultElementObjectPropertyValue()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return contextInit;
    }

    @Override
    public Element createElementInstance(X4OLanguageContext context, Class<?> objectClass) {
        for (X4OLanguageModule modContext : this.getLanguageModules()) {
            for (ElementNamespaceContext nsContext : modContext.getElementNamespaceContexts()) {
                for (ElementClass ec : nsContext.getElementClasses()) {
                    if (ec.getObjectClass() == null || !ec.getObjectClass().equals(objectClass)) continue;
                    try {
                        return nsContext.getElementNamespaceInstanceProvider().createElementInstance(context, ec.getId());
                    }
                    catch (ElementNamespaceInstanceProviderException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Could not find ElementClass for: " + objectClass.getName());
    }

    @Override
    public List<ElementBindingHandler> findElementBindingHandlers(Object parent) {
        ArrayList<ElementBindingHandler> result = new ArrayList<ElementBindingHandler>(50);
        for (int i = 0; i < this.elementLanguageModules.size(); ++i) {
            X4OLanguageModule module = this.elementLanguageModules.get(i);
            this.findElementBindingHandlerInList(parent, null, result, module.getElementBindingHandlers(), false);
        }
        for (ElementInterface ei : this.findElementInterfaces(parent)) {
            this.findElementBindingHandlerInList(parent, null, result, ei.getElementBindingHandlers(), false);
        }
        return result;
    }

    @Override
    public List<ElementBindingHandler> findElementBindingHandlers(Object parent, Object child) {
        ArrayList<ElementBindingHandler> result = new ArrayList<ElementBindingHandler>(50);
        for (int i = 0; i < this.elementLanguageModules.size(); ++i) {
            X4OLanguageModule module = this.elementLanguageModules.get(i);
            this.findElementBindingHandlerInList(parent, child, result, module.getElementBindingHandlers(), true);
        }
        for (ElementInterface ei : this.findElementInterfaces(parent)) {
            this.findElementBindingHandlerInList(parent, child, result, ei.getElementBindingHandlers(), true);
        }
        return result;
    }

    private void findElementBindingHandlerInList(Object parent, Object child, List<ElementBindingHandler> result, List<ElementBindingHandler> checkList, boolean checkChild) {
        for (ElementBindingHandler binding : checkList) {
            boolean parentBind = false;
            parentBind = parent instanceof Class ? binding.getBindParentClass().isAssignableFrom((Class)parent) : binding.getBindParentClass().isInstance(parent);
            if (!parentBind) continue;
            if (!checkChild) {
                result.add(binding);
                continue;
            }
            boolean childBind = false;
            for (Class<?> childClass : binding.getBindChildClasses()) {
                if (child instanceof Class && childClass.isAssignableFrom((Class)child)) {
                    childBind = true;
                    break;
                }
                if (!childClass.isInstance(child)) continue;
                childBind = true;
                break;
            }
            if (!(parentBind & childBind)) continue;
            result.add(binding);
        }
    }

    @Override
    public List<ElementInterface> findElementInterfaces(Object elementObject) {
        if (elementObject == null) {
            throw new NullPointerException("Can't search for null object.");
        }
        ArrayList<ElementInterface> result = new ArrayList<ElementInterface>(50);
        for (int i = 0; i < this.elementLanguageModules.size(); ++i) {
            X4OLanguageModule module = this.elementLanguageModules.get(i);
            for (ElementInterface ei : module.getElementInterfaces()) {
                Class<?> eClass = ei.getInterfaceClass();
                this.logger.finest("Checking interface handler: " + ei + " for class: " + eClass);
                if (elementObject instanceof Class && eClass.isAssignableFrom((Class)elementObject)) {
                    this.logger.finer("Found interface match from class; " + elementObject);
                    result.add(ei);
                    continue;
                }
                if (!eClass.isInstance(elementObject)) continue;
                this.logger.finer("Found interface match from object; " + elementObject);
                result.add(ei);
            }
        }
        return result;
    }

    @Override
    public ElementNamespaceContext findElementNamespaceContext(String namespaceUri) {
        ElementNamespaceContext result = null;
        for (int i = 0; i < this.elementLanguageModules.size(); ++i) {
            X4OLanguageModule module = this.elementLanguageModules.get(i);
            result = module.getElementNamespaceContext(namespaceUri);
            if (result == null) continue;
            return result;
        }
        return result;
    }
}

