Mojo Public C++ API
===================

This directory contains C++ language bindings for the Mojo Public API.

A number of subdirectories provide wrappers for the lower-level C APIs (in
subdirectories of the same name, under mojo/public/c/). Typically, these
wrappers provide increased convenience and/or type-safety.

Other subdirectories provide support (static) libraries of various sorts. In
this case, the organization is to have the public interface for the library
defined in header files in the subdirectory itself and the implementation of the
library at a lower level, under a lib (sub)subdirectory. A developer should be
able to substitute their own implementation of any such support library, and
expect other support libraries, which may depend on that library, to work
properly.

Bindings
--------

The bindings/ subdirectory contains a support (static) library needed by the
code generated by the bindings generator tool (in mojo/public/tools/bindings/),
which translates Mojo IDL (.mojom) files into idiomatic C++ (among other
languages).

System
------

The system/ subdirectory contains C++ wrappers (and some additional helpers) of
the API defined in mojo/public/c/system/, which defines the basic, "core" API,
especially used to communicate with Mojo services.

Test Support
------------

The test_support/ subdirectory contains C++ wrappers of the test-only API
defined in mojo/public/c/test_support/. It is not meant for general use by Mojo
applications.
