/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;

public class SeparatorWrapCheck
extends AbstractOptionCheck<WrapOption> {
    public static final String LINE_PREVIOUS = "line.previous";
    public static final String LINE_NEW = "line.new";

    public SeparatorWrapCheck() {
        super(WrapOption.EOL, WrapOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{59, 74};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{59, 74, 45, 171, 170, 76, 77, 17, 48};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        int colNo = ast.getColumnNo();
        int lineNo = ast.getLineNo();
        String currentLine = this.getLines()[lineNo - 1];
        String substringAfterToken = currentLine.substring(colNo + text.length()).trim();
        String substringBeforeToken = currentLine.substring(0, colNo).trim();
        WrapOption wSp = (WrapOption)((Object)this.getAbstractOption());
        if (wSp == WrapOption.EOL && substringBeforeToken.length() == 0) {
            this.log(lineNo, colNo, LINE_PREVIOUS, text);
        } else if (wSp == WrapOption.NL && substringAfterToken.length() == 0) {
            this.log(lineNo, colNo, LINE_NEW, text);
        }
    }
}

