/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.PriorityQueueImpl;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

final class PriorityQueueImplWithAccessChecking
extends PriorityQueueImpl {
    private static final FixedKeyMapCreator MOVE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator COPY_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator DELETE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("messageIds", "selector", "limit");
    private static final FixedKeyMapCreator GET_MESSAGE_CONTENT_MAP_CREATOR = new FixedKeyMapCreator("messageId", "limit", "returnJson", "decompressBeforeLimiting");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_MAP_CREATOR = new FixedKeyMapCreator("first", "last", "includeHeaders");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_BY_ID_MAP_CREATOR = new FixedKeyMapCreator("messageId", "includeHeaders");
    private static final FixedKeyMapCreator REENQUEUE_MESSAGE_FOR_PRIORITY_CHANGE_MAP_CREATOR = new FixedKeyMapCreator("messageId", "newPriority");
    private static final FixedKeyMapCreator REENQUEUE_MESSAGES_FOR_PRIORITY_CHANGE_MAP_CREATOR = new FixedKeyMapCreator("selector", "newPriority");

    PriorityQueueImplWithAccessChecking(Map<String, Object> attributes, QueueManagingVirtualHost<?> queuemanagingvirtualhost) {
        super(attributes, queuemanagingvirtualhost);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(PriorityQueueImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return PriorityQueueImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(PriorityQueueImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return PriorityQueueImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public Collection<PublishingLink> getPublishingLinks() {
        return super.getPublishingLinks();
    }

    @Override
    public Collection<QueueConsumer<?, ?>> getConsumers() {
        return super.getConsumers();
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD("resetStatistics"));
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                PriorityQueueImplWithAccessChecking.super.resetStatistics();
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return PriorityQueueImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "resetStatistics";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public List<Long> moveMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("moveMessages"), MOVE_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.moveMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> copyMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("copyMessages"), COPY_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.copyMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> deleteMessages(List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("deleteMessages"), DELETE_MESSAGES_MAP_CREATOR.createMap(messageIds, selector, limit));
        return super.deleteMessages(messageIds, selector, limit);
    }

    @Override
    public long clearQueue() {
        this.authorise(Operation.INVOKE_METHOD("clearQueue"));
        return super.clearQueue();
    }

    @Override
    public Content getMessageContent(long messageId, long limit, boolean returnJson, boolean decompressBeforeLimiting) {
        this.authorise(Operation.INVOKE_METHOD("getMessageContent"), GET_MESSAGE_CONTENT_MAP_CREATOR.createMap(messageId, limit, returnJson, decompressBeforeLimiting));
        return super.getMessageContent(messageId, limit, returnJson, decompressBeforeLimiting);
    }

    @Override
    public List<MessageInfo> getMessageInfo(int first, int last, boolean includeHeaders) {
        this.authorise(Operation.INVOKE_METHOD("getMessageInfo"), GET_MESSAGE_INFO_MAP_CREATOR.createMap(first, last, includeHeaders));
        return super.getMessageInfo(first, last, includeHeaders);
    }

    @Override
    public MessageInfo getMessageInfoById(long messageId, boolean includeHeaders) {
        this.authorise(Operation.INVOKE_METHOD("getMessageInfoById"), GET_MESSAGE_INFO_BY_ID_MAP_CREATOR.createMap(messageId, includeHeaders));
        return super.getMessageInfoById(messageId, includeHeaders);
    }

    @Override
    public long reenqueueMessageForPriorityChange(long messageId, int newPriority) {
        this.authorise(Operation.INVOKE_METHOD("reenqueueMessageForPriorityChange"), REENQUEUE_MESSAGE_FOR_PRIORITY_CHANGE_MAP_CREATOR.createMap(messageId, newPriority));
        return super.reenqueueMessageForPriorityChange(messageId, newPriority);
    }

    @Override
    public List<Long> reenqueueMessagesForPriorityChange(String selector, int newPriority) {
        this.authorise(Operation.INVOKE_METHOD("reenqueueMessagesForPriorityChange"), REENQUEUE_MESSAGES_FOR_PRIORITY_CHANGE_MAP_CREATOR.createMap(selector, newPriority));
        return super.reenqueueMessagesForPriorityChange(selector, newPriority);
    }
}

