/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.AccessController;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;

public final class SubjectFixedResultAccessControl
implements AccessControl<FixedResultSecurityToken> {
    private final Result _default;
    private final ResultCalculator _calculator;

    public SubjectFixedResultAccessControl(ResultCalculator calculator, Result defaultResult) {
        this._default = defaultResult;
        this._calculator = calculator;
    }

    @Override
    public Result getDefault() {
        return this._default;
    }

    @Override
    public FixedResultSecurityToken newToken() {
        return this.newToken(Subject.getSubject(AccessController.getContext()));
    }

    @Override
    public FixedResultSecurityToken newToken(Subject subject) {
        return new FixedResultSecurityToken(this._calculator.getResult(subject));
    }

    @Override
    public Result authorise(FixedResultSecurityToken token, Operation operation, PermissionedObject configuredObject) {
        return token == null ? this._calculator.getResult(Subject.getSubject(AccessController.getContext())) : token.getResult();
    }

    @Override
    public Result authorise(FixedResultSecurityToken token, Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        return token == null ? this._calculator.getResult(Subject.getSubject(AccessController.getContext())) : token.getResult();
    }

    public static interface ResultCalculator {
        public Result getResult(Subject var1);
    }

    static final class FixedResultSecurityToken
    implements SecurityToken {
        private final Result _result;

        private FixedResultSecurityToken(Result result) {
            this._result = result;
        }

        private Result getResult() {
            return this._result;
        }
    }
}

