/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.services.TinkerServiceRegistry;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphVariables;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV1;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV2;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;

public abstract class AbstractTinkerGraph
implements Graph {
    public static final String GREMLIN_TINKERGRAPH_VERTEX_ID_MANAGER = "gremlin.tinkergraph.vertexIdManager";
    public static final String GREMLIN_TINKERGRAPH_EDGE_ID_MANAGER = "gremlin.tinkergraph.edgeIdManager";
    public static final String GREMLIN_TINKERGRAPH_VERTEX_PROPERTY_ID_MANAGER = "gremlin.tinkergraph.vertexPropertyIdManager";
    public static final String GREMLIN_TINKERGRAPH_DEFAULT_VERTEX_PROPERTY_CARDINALITY = "gremlin.tinkergraph.defaultVertexPropertyCardinality";
    public static final String GREMLIN_TINKERGRAPH_GRAPH_LOCATION = "gremlin.tinkergraph.graphLocation";
    public static final String GREMLIN_TINKERGRAPH_GRAPH_FORMAT = "gremlin.tinkergraph.graphFormat";
    public static final String GREMLIN_TINKERGRAPH_ALLOW_NULL_PROPERTY_VALUES = "gremlin.tinkergraph.allowNullPropertyValues";
    public static final String GREMLIN_TINKERGRAPH_SERVICE = "gremlin.tinkergraph.service";
    protected AtomicLong currentId = new AtomicLong(-1L);
    protected TinkerGraphVariables variables = null;
    protected TinkerGraphComputerView graphComputerView = null;
    protected AbstractTinkerIndex<TinkerVertex> vertexIndex = null;
    protected AbstractTinkerIndex<TinkerEdge> edgeIndex = null;
    protected IdManager<Vertex> vertexIdManager;
    protected IdManager<Edge> edgeIdManager;
    protected IdManager<VertexProperty> vertexPropertyIdManager;
    protected VertexProperty.Cardinality defaultVertexPropertyCardinality;
    protected boolean allowNullPropertyValues;
    protected TinkerServiceRegistry serviceRegistry;
    protected Configuration configuration;
    protected String graphLocation;
    protected String graphFormat;

    public abstract Vertex addVertex(Object ... var1);

    public abstract void removeVertex(Object var1);

    public abstract Edge addEdge(TinkerVertex var1, TinkerVertex var2, String var3, Object ... var4);

    public abstract void removeEdge(Object var1);

    public void touch(TinkerVertex vertex) {
    }

    public void touch(TinkerEdge edge) {
    }

    public abstract Vertex vertex(Object var1);

    public abstract Iterator<Vertex> vertices(Object ... var1);

    public abstract Edge edge(Object var1);

    public abstract Iterator<Edge> edges(Object ... var1);

    public abstract Transaction tx();

    public abstract int getVerticesCount();

    public abstract boolean hasVertex(Object var1);

    public abstract int getEdgesCount();

    public abstract boolean hasEdge(Object var1);

    protected void loadGraph() {
        File f = new File(this.graphLocation);
        if (f.exists() && f.isFile()) {
            try {
                if (this.graphFormat.equals("graphml")) {
                    ((GraphMLIo)this.io(IoCore.graphml())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("graphson")) {
                    ((GraphSONIo)this.io(IoCore.graphson())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("gryo")) {
                    ((GryoIo)this.io(IoCore.gryo())).readGraph(this.graphLocation);
                } else {
                    this.io(IoCore.createIoBuilder((String)this.graphFormat)).readGraph(this.graphLocation);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Could not load graph at %s with %s", this.graphLocation, this.graphFormat), ex);
            }
        }
    }

    protected void saveGraph() {
        File f = new File(this.graphLocation);
        if (f.exists()) {
            f.delete();
        } else {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
        }
        try {
            if (this.graphFormat.equals("graphml")) {
                ((GraphMLIo)this.io(IoCore.graphml())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("graphson")) {
                ((GraphSONIo)this.io(IoCore.graphson())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("gryo")) {
                ((GryoIo)this.io(IoCore.gryo())).writeGraph(this.graphLocation);
            } else {
                this.io(IoCore.createIoBuilder((String)this.graphFormat)).writeGraph(this.graphLocation);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Could not save graph at %s with %s", this.graphLocation, this.graphFormat), ex);
        }
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        if (builder.requiresVersion((Object)GryoVersion.V1_0) || builder.requiresVersion((Object)GraphSONVersion.V1_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV1.instance())).create();
        }
        if (builder.requiresVersion((Object)GraphSONVersion.V2_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV2.instance())).create();
        }
        return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV3.instance())).create();
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        if (!graphComputerClass.equals(TinkerGraphComputer.class)) {
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        return (C)new TinkerGraphComputer(this);
    }

    public GraphComputer compute() {
        return new TinkerGraphComputer(this);
    }

    public Graph.Variables variables() {
        if (null == this.variables) {
            this.variables = new TinkerGraphVariables();
        }
        return this.variables;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)("vertices:" + this.getVerticesCount() + " edges:" + this.getEdgesCount()));
    }

    public void clear() {
        this.variables = null;
        this.currentId.set(-1L);
        this.vertexIndex = null;
        this.edgeIndex = null;
        this.graphComputerView = null;
    }

    public void close() {
        if (this.graphLocation != null) {
            this.saveGraph();
        }
        this.serviceRegistry.close();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    protected abstract void addOutEdge(TinkerVertex var1, String var2, Edge var3);

    protected abstract void addInEdge(TinkerVertex var1, String var2, Edge var3);

    protected TinkerVertex createTinkerVertex(Object id, String label, AbstractTinkerGraph graph) {
        return new TinkerVertex(id, label, graph);
    }

    protected TinkerVertex createTinkerVertex(Object id, String label, AbstractTinkerGraph graph, long currentVersion) {
        return new TinkerVertex(id, label, graph, currentVersion);
    }

    protected TinkerEdge createTinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex) {
        return new TinkerEdge(id, outVertex, label, inVertex);
    }

    protected TinkerEdge createTinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex, long currentVersion) {
        return new TinkerEdge(id, outVertex, label, inVertex, currentVersion);
    }

    public <E extends Element> Set<String> getIndexedKeys(Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return null == this.vertexIndex ? Collections.emptySet() : this.vertexIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return null == this.edgeIndex ? Collections.emptySet() : this.edgeIndex.getIndexedKeys();
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    protected static <T extends Element> IdManager<T> selectIdManager(Configuration config, String configKey, Class<T> clazz) {
        String vertexIdManagerConfigValue = config.getString(configKey, DefaultIdManager.ANY.name());
        try {
            return DefaultIdManager.valueOf(vertexIdManagerConfigValue);
        }
        catch (IllegalArgumentException iae) {
            try {
                return (IdManager)Class.forName(vertexIdManagerConfigValue).newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Could not configure TinkerGraph %s id manager with %s", clazz.getSimpleName(), vertexIdManagerConfigValue));
            }
        }
    }

    protected TinkerServiceRegistry.TinkerServiceFactory instantiate(String className) {
        try {
            return (TinkerServiceRegistry.TinkerServiceFactory)Class.forName(className).getConstructor(AbstractTinkerGraph.class).newInstance(this);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static enum DefaultIdManager implements IdManager
    {
        LONG{

            public Long getNextId(AbstractTinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).filter(id -> !graph.hasVertex(id) && !graph.hasEdge(id)).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Long) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).longValue();
                }
                if (id instanceof String) {
                    try {
                        return Long.parseLong((String)id);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(Long.class, id));
                    }
                }
                throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(Long.class, id));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        INTEGER{

            public Integer getNextId(AbstractTinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).map(Long::intValue).filter(id -> !graph.hasVertex(id) && !graph.hasEdge(id)).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Integer) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).intValue();
                }
                if (id instanceof String) {
                    try {
                        return Integer.parseInt((String)id);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(Integer.class, id));
                    }
                }
                throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(Integer.class, id));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        UUID{

            public UUID getNextId(AbstractTinkerGraph graph) {
                return java.util.UUID.randomUUID();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof UUID) {
                    return id;
                }
                if (id instanceof String) {
                    try {
                        return java.util.UUID.fromString((String)id);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(UUID.class, id));
                    }
                }
                throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(UUID.class, id));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof UUID || id instanceof String;
            }
        }
        ,
        ANY{

            public Long getNextId(AbstractTinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).filter(id -> !graph.hasVertex(id) && !graph.hasEdge(id)).findAny().get();
            }

            public Object convert(Object id) {
                return id;
            }

            @Override
            public boolean allow(Object id) {
                return true;
            }
        }
        ,
        STRING{

            public String getNextId(AbstractTinkerGraph graph) {
                return java.util.UUID.randomUUID().toString();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof String) {
                    if (((String)id).isEmpty()) {
                        throw new IllegalArgumentException("Expected a non-empty string but received an empty string.");
                    }
                    return id;
                }
                throw new IllegalArgumentException(DefaultIdManager.createErrorMessage(String.class, id));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof String && !((String)id).isEmpty();
            }
        };


        private static String createErrorMessage(Class<?> expectedType, Object id) {
            return String.format("Expected an id that is convertible to %s but received %s - [%s]", expectedType, id.getClass(), id);
        }
    }

    public static interface IdManager<T> {
        public T getNextId(AbstractTinkerGraph var1);

        public T convert(Object var1);

        public boolean allow(Object var1);
    }

    public class TinkerGraphVertexPropertyFeatures
    implements Graph.Features.VertexPropertyFeatures {
        protected TinkerGraphVertexPropertyFeatures() {
        }

        public boolean supportsNullPropertyValues() {
            return AbstractTinkerGraph.this.allowNullPropertyValues;
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return AbstractTinkerGraph.this.vertexIdManager.allow(id);
        }
    }

    public class TinkerGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        protected TinkerGraphEdgeFeatures() {
        }

        public boolean supportsNullPropertyValues() {
            return AbstractTinkerGraph.this.allowNullPropertyValues;
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return AbstractTinkerGraph.this.edgeIdManager.allow(id);
        }
    }

    public class TinkerGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        private final TinkerGraphVertexPropertyFeatures vertexPropertyFeatures;

        protected TinkerGraphVertexFeatures() {
            this.vertexPropertyFeatures = new TinkerGraphVertexPropertyFeatures();
        }

        public boolean supportsNullPropertyValues() {
            return AbstractTinkerGraph.this.allowNullPropertyValues;
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return AbstractTinkerGraph.this.vertexIdManager.allow(id);
        }

        public VertexProperty.Cardinality getCardinality(String key) {
            return AbstractTinkerGraph.this.defaultVertexPropertyCardinality;
        }
    }
}

