/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.Handler;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.UserAgent;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Channelizer
extends ChannelHandler {
    public void init(Connection var1);

    public void close(Channel var1);

    default public void connected() {
    }

    default public String getScheme(boolean sslEnabled) {
        return sslEnabled ? "https" : "http";
    }

    public static final class HttpChannelizer
    extends AbstractChannelizer {
        private HttpClientCodec handler;
        private HttpGremlinRequestEncoder gremlinRequestEncoder;
        private HttpGremlinResponseDecoder gremlinResponseDecoder;

        @Override
        public void init(Connection connection) {
            super.init(connection);
            if (connection.getClient() instanceof Client.SessionedClient) {
                throw new IllegalStateException(String.format("Cannot use sessions or tx() with %s", HttpChannelizer.class.getSimpleName()));
            }
            this.gremlinRequestEncoder = new HttpGremlinRequestEncoder(this.cluster.getSerializer(), this.cluster.getRequestInterceptor(), this.cluster.isUserAgentOnConnectEnabled());
            this.gremlinResponseDecoder = new HttpGremlinResponseDecoder(this.cluster.getSerializer());
        }

        @Override
        public void connected() {
            super.connected();
        }

        @Override
        public boolean supportsSsl() {
            String scheme = this.connection.getUri().getScheme();
            return "https".equalsIgnoreCase(scheme);
        }

        @Override
        public void configure(ChannelPipeline pipeline) {
            String scheme = this.connection.getUri().getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("Unsupported scheme (only http: or https: supported): " + scheme);
            }
            if (!this.supportsSsl() && "https".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("To use https scheme ensure that enableSsl is set to true in configuration");
            }
            int maxContentLength = this.cluster.connectionPoolSettings().maxContentLength;
            this.handler = new HttpClientCodec();
            pipeline.addLast("http-codec", (ChannelHandler)this.handler);
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength));
            pipeline.addLast("gremlin-encoder", (ChannelHandler)this.gremlinRequestEncoder);
            pipeline.addLast("gremlin-decoder", (ChannelHandler)this.gremlinResponseDecoder);
        }
    }

    public static final class WebSocketChannelizer
    extends AbstractChannelizer {
        private static final Logger logger = LoggerFactory.getLogger(WebSocketChannelizer.class);
        private WebSocketClientHandler handler;
        private WebSocketGremlinRequestEncoder gremlinRequestEncoder;
        private WebSocketGremlinResponseDecoder gremlinResponseDecoder;

        @Override
        public void init(Connection connection) {
            super.init(connection);
            this.gremlinRequestEncoder = new WebSocketGremlinRequestEncoder(true, this.cluster.getSerializer());
            this.gremlinResponseDecoder = new WebSocketGremlinResponseDecoder(this.cluster.getSerializer());
        }

        @Override
        public void close(Channel channel) {
            if (channel.isOpen()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending CloseWS frame to server from channel={}", (Object)channel.id().asShortText());
                }
                channel.writeAndFlush((Object)new CloseWebSocketFrame());
            }
        }

        @Override
        public boolean supportsSsl() {
            String scheme = this.connection.getUri().getScheme();
            return "wss".equalsIgnoreCase(scheme);
        }

        @Override
        public void configure(ChannelPipeline pipeline) {
            String scheme = this.connection.getUri().getScheme();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("Unsupported scheme (only ws: or wss: supported): " + scheme);
            }
            if (!this.supportsSsl() && "wss".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("To use wss scheme ensure that enableSsl is set to true in configuration");
            }
            int maxContentLength = this.cluster.connectionPoolSettings().maxContentLength;
            DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
            if (this.connection.getCluster().isUserAgentOnConnectEnabled()) {
                httpHeaders.set("User-Agent", (Object)UserAgent.USER_AGENT);
            }
            this.handler = new WebSocketClientHandler((WebSocketClientHandshaker)new WebSocketClientHandler.InterceptedWebSocketClientHandshaker13(this.connection.getUri(), WebSocketVersion.V13, null, true, (HttpHeaders)httpHeaders, maxContentLength, true, false, -1L, this.cluster.getRequestInterceptor()), this.cluster.getConnectionSetupTimeout(), this.supportsSsl());
            int keepAliveInterval = Math.toIntExact(TimeUnit.SECONDS.convert(this.cluster.connectionPoolSettings().keepAliveInterval, TimeUnit.MILLISECONDS));
            pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength));
            if (this.connection.getCluster().enableCompression()) {
                pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
            }
            pipeline.addLast("idle-state-Handler", (ChannelHandler)new IdleStateHandler(0, keepAliveInterval, 0));
            pipeline.addLast("ws-handler", (ChannelHandler)this.handler);
            pipeline.addLast("gremlin-encoder", (ChannelHandler)this.gremlinRequestEncoder);
            pipeline.addLast("gremlin-decoder", (ChannelHandler)this.gremlinResponseDecoder);
        }

        @Override
        public void connected() {
            try {
                this.handler.handshakeFuture().sync();
            }
            catch (Exception ex) {
                String errMsg = "";
                errMsg = ex instanceof TimeoutException ? "Timed out while waiting to complete the connection setup. Consider increasing the WebSocket handshake timeout duration." : "Could not complete connection setup to the server. Ensure that SSL is correctly configured at both the client and the server. Ensure that client WebSocket handshake protocol matches the server. Ensure that the server is still reachable.";
                throw new ConnectionException(this.connection.getUri(), errMsg, ex);
            }
        }

        @Override
        public String getScheme(boolean sslEnabled) {
            return sslEnabled ? "wss" : "ws";
        }
    }

    public static abstract class AbstractChannelizer
    extends ChannelInitializer<SocketChannel>
    implements Channelizer {
        protected Connection connection;
        protected Cluster cluster;
        private ConcurrentMap<UUID, ResultQueue> pending;
        protected static final String PIPELINE_GREMLIN_SASL_HANDLER = "gremlin-sasl-handler";
        protected static final String PIPELINE_GREMLIN_HANDLER = "gremlin-handler";
        public static final String PIPELINE_SSL_HANDLER = "gremlin-ssl-handler";

        public boolean supportsSsl() {
            return this.cluster.connectionPoolSettings().enableSsl;
        }

        public abstract void configure(ChannelPipeline var1);

        public void finalize(ChannelPipeline pipeline) {
        }

        @Override
        public void close(Channel channel) {
        }

        @Override
        public void init(Connection connection) {
            this.connection = connection;
            this.cluster = connection.getCluster();
            this.pending = connection.getPending();
        }

        protected void initChannel(SocketChannel socketChannel) throws Exception {
            Optional<Object> sslCtx;
            ChannelPipeline pipeline = socketChannel.pipeline();
            if (this.supportsSsl()) {
                try {
                    sslCtx = Optional.of(this.cluster.createSSLContext());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                sslCtx = Optional.empty();
            }
            if (sslCtx.isPresent()) {
                SslHandler sslHandler = ((SslContext)sslCtx.get()).newHandler(socketChannel.alloc(), this.connection.getUri().getHost(), this.connection.getUri().getPort());
                sslHandler.setHandshakeTimeoutMillis(0L);
                pipeline.addLast(PIPELINE_SSL_HANDLER, (ChannelHandler)sslHandler);
            }
            this.configure(pipeline);
            pipeline.addLast(PIPELINE_GREMLIN_SASL_HANDLER, (ChannelHandler)new Handler.GremlinSaslAuthenticationHandler(this.cluster.authProperties()));
            pipeline.addLast(PIPELINE_GREMLIN_HANDLER, (ChannelHandler)new Handler.GremlinResponseHandler(this.pending));
        }
    }
}

