/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.store.imap.connection;

import jakarta.mail.MessagingException;
import java.util.List;
import org.apache.geronimo.mail.store.imap.connection.IMAPResponseTokenizer;
import org.apache.geronimo.mail.store.imap.connection.IMAPUntaggedResponse;

public class IMAPStatusResponse
extends IMAPUntaggedResponse {
    public String mailbox;
    public int messages = -1;
    public int recentMessages = -1;
    public int unseenMessages = -1;
    public long uidNext = -1L;
    public long uidValidity = -1L;

    public IMAPStatusResponse(byte[] data, IMAPResponseTokenizer source) throws MessagingException {
        super("STATUS", data);
        this.mailbox = source.readEncodedString();
        List flags = source.readStringList();
        if (flags == null) {
            return;
        }
        for (int i = 0; i < flags.size(); i += 2) {
            long value;
            String field = ((String)flags.get(i)).toUpperCase();
            String stringValue = (String)flags.get(i + 1);
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                throw new MessagingException("Invalid IMAP Status response", (Exception)e);
            }
            if (field.equals("MESSAGES")) {
                this.messages = (int)value;
                continue;
            }
            if (field.equals("RECENT")) {
                this.recentMessages = (int)value;
                continue;
            }
            if (field.equals("UIDNEXT")) {
                this.uidNext = value;
                continue;
            }
            if (field.equals("UIDVALIDITY")) {
                this.uidValidity = value;
                continue;
            }
            if (!field.equals("UNSEEN")) continue;
            this.unseenMessages = (int)value;
        }
    }
}

