/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.map;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.resource.Resource;

public class CryptoDataMapLoader
implements DataMapLoader {
    protected final DataMapLoader delegate;
    protected final ColumnMapper columnMapper;
    protected final JdbcEventLogger jdbcEventLogger;

    public CryptoDataMapLoader(@Inject DataMapLoader delegate, @Inject ColumnMapper columnMapper, @Inject JdbcEventLogger jdbcEventLogger) {
        this.delegate = delegate;
        this.columnMapper = columnMapper;
        this.jdbcEventLogger = jdbcEventLogger;
    }

    public DataMap load(Resource configurationResource) throws CayenneRuntimeException {
        DataMap result = this.delegate.load(configurationResource);
        for (ObjEntity entity : result.getObjEntities()) {
            if (entity.getLockType() != 1) continue;
            for (ObjAttribute attr : entity.getAttributes()) {
                if (!attr.isUsedForLocking() || attr.getDbAttribute() == null || !this.columnMapper.isEncrypted(attr.getDbAttribute())) continue;
                String attrName = entity.getName() + "." + attr.getName();
                this.jdbcEventLogger.log("WARN: Encrypted attributes like '" + attrName + "' cannot be used for optimistic locking. Locking will be disabled for this attribute.");
                attr.setUsedForLocking(false);
            }
        }
        return result;
    }
}

