/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbAttribute;

class ColumnDescriptorStage
implements TranslationStage {
    ColumnDescriptorStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        int i = 0;
        for (ResultNodeDescriptor resultNode : context.getResultNodeList()) {
            context.getSelectBuilder().result(resultNode::getNode);
            if (!resultNode.isInDataRow()) continue;
            DbAttribute attribute = resultNode.getDbAttribute();
            String name = attribute != null ? attribute.getName() : "__c" + i++;
            ColumnDescriptor descriptor = new ColumnDescriptor(name, resultNode.getJdbcType(), resultNode.getJavaType());
            descriptor.setAttribute(attribute);
            descriptor.setDataRowKey(resultNode.getDataRowKey());
            context.getColumnDescriptors().add(descriptor);
        }
    }
}

