/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.combo.CustomTypeComboBoxEditor;
import org.apache.cayenne.modeler.util.combo.SuggestionList;

public class AutoCompletion
implements FocusListener,
KeyListener,
Runnable {
    public static final String AUTOCOMPLETION_PROPERTY = "JComboBox.autoCompletion";
    private final SuggestionList suggestionList;
    private final JComboBox comboBox;
    private final JTextComponent textEditor;
    private final boolean allowsUserValues;

    protected AutoCompletion(JComboBox comboBox, boolean strict, boolean allowsUserValues) {
        this.comboBox = comboBox;
        this.textEditor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        this.allowsUserValues = allowsUserValues;
        this.suggestionList = new SuggestionList(comboBox, strict);
        comboBox.putClientProperty(AUTOCOMPLETION_PROPERTY, Boolean.TRUE);
    }

    public static void enable(JComboBox comboBox, boolean strict, boolean allowsUserValues) {
        comboBox.setEditable(true);
        KeyListener[] listeners = (KeyListener[])comboBox.getEditor().getEditorComponent().getListeners(KeyListener.class);
        comboBox.setEditor(new CustomTypeComboBoxEditor(comboBox, allowsUserValues));
        for (KeyListener listener : listeners) {
            comboBox.getEditor().getEditorComponent().addKeyListener(listener);
        }
        AutoCompletion ac = new AutoCompletion(comboBox, strict, allowsUserValues);
        comboBox.addFocusListener(ac);
        ac.textEditor.addKeyListener(ac);
        SwingUtilities.replaceUIActionMap(comboBox, null);
    }

    public static void enable(JComboBox comboBox) {
        AutoCompletion.enable(comboBox, true, false);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.suggestionList.hide();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 8 || e.getKeyCode() == 10) {
            String text = this.textEditor.getText();
            if (this.comboBox.isShowing()) {
                this.suggestionList.hide();
                this.suggestionList.filter(text);
                this.suggestionList.show();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void run() {
        String text = this.textEditor.getText();
        this.suggestionList.hide();
        if (this.comboBox.isShowing()) {
            this.suggestionList.filter(text);
            if (this.suggestionList.getItemCount() > 0) {
                this.suggestionList.show();
            }
        }
    }

    private void handleKeyPressed(KeyEvent e) {
        boolean suggest = this.suggestionList.isVisible();
        if (suggest) {
            this.processKeyPressedWhenSuggestionListIsVisible(e);
        } else {
            this.processKeyPressedWhenSuggestionListIsInvisible(e);
        }
        this.suggestionListScrolling();
    }

    private void processKeyPressedWhenSuggestionListIsInvisible(KeyEvent e) {
        int next;
        int sel = this.comboBox.getSelectedIndex();
        int max = this.comboBox.getItemCount() - 1;
        switch (e.getKeyCode()) {
            case 38: 
            case 104: {
                next = sel - 1;
                break;
            }
            case 40: 
            case 98: {
                next = sel + 1;
                break;
            }
            case 33: {
                next = sel - this.comboBox.getMaximumRowCount();
                break;
            }
            case 34: {
                next = sel + this.comboBox.getMaximumRowCount();
                break;
            }
            case 36: {
                next = 0;
                break;
            }
            case 35: {
                next = max;
                break;
            }
            case 10: 
            case 27: {
                return;
            }
            default: {
                SwingUtilities.invokeLater(this);
                return;
            }
        }
        e.consume();
        this.handleNavigationKeys(false, next, sel, max);
    }

    private void processKeyPressedWhenSuggestionListIsVisible(KeyEvent e) {
        int next;
        int sel = this.suggestionList.getSelectedIndex();
        int max = this.suggestionList.getItemCount() - 1;
        switch (e.getKeyCode()) {
            case 38: 
            case 104: {
                next = sel - 1;
                break;
            }
            case 40: 
            case 98: {
                next = sel + 1;
                break;
            }
            case 33: {
                next = sel - this.comboBox.getMaximumRowCount();
                break;
            }
            case 34: {
                next = sel + this.comboBox.getMaximumRowCount();
                break;
            }
            case 36: {
                next = 0;
                break;
            }
            case 35: {
                next = max;
                break;
            }
            case 10: {
                this.processEnterPressed();
                return;
            }
            case 27: {
                this.suggestionList.hide();
                return;
            }
            default: {
                SwingUtilities.invokeLater(this);
                return;
            }
        }
        e.consume();
        this.handleNavigationKeys(true, next, sel, max);
    }

    private void processEnterPressed() {
        Object value = this.suggestionList.getSelectedValue();
        if (!this.allowsUserValues && value == null && this.suggestionList.getItemCount() > 0) {
            value = this.suggestionList.getItemAt(0);
        }
        if (value != null || !this.allowsUserValues) {
            this.comboBox.setSelectedItem(value);
        }
        this.suggestionList.hide();
    }

    private void handleNavigationKeys(boolean suggest, int next, int sel, int max) {
        if (!suggest && !this.comboBox.isPopupVisible()) {
            this.comboBox.setPopupVisible(true);
            return;
        }
        if (this.comboBox.getItemCount() > 0) {
            if (next < 0) {
                next = 0;
            }
            if (next > max) {
                next = max;
            }
            if (next != sel) {
                if (suggest) {
                    this.suggestionList.setSelectedIndex(next);
                } else {
                    this.comboBox.setPopupVisible(true);
                    this.comboBox.setSelectedIndex(next);
                }
            }
            this.textEditor.requestFocus();
        }
    }

    private void suggestionListScrolling() {
        JList<Object> list = this.suggestionList.getList();
        int selectedIndex = this.suggestionList.getSelectedIndex();
        list.ensureIndexIsVisible(selectedIndex);
    }
}

