/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.Random;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.DynamicCombinedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderConfigurationWrapperFactory;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.CopyObjectDefaultHandler;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedBuilderProperties;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.MultiFileConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.CombinedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.MultiFileBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDynamicCombinedConfiguration {
    private static final String PATTERN = "${sys:Id}";
    private static final String PATTERN1 = "target/test-classes/testMultiConfiguration_${sys:Id}.xml";
    private static final String DEFAULT_FILE = "target/test-classes/testMultiConfiguration_default.xml";
    private static final File MULTI_TENENT_FILE = ConfigurationAssert.getTestFile("testMultiTenentConfigurationBuilder4.xml");
    private static final File MULTI_DYNAMIC_FILE = ConfigurationAssert.getTestFile("testMultiTenentConfigurationBuilder5.xml");
    private static final int THREAD_COUNT = 3;
    private static final int LOOP_COUNT = 100;
    private static Parameters parameters;
    @TempDir
    public File tempFolder;

    @BeforeAll
    public static void setUpOnce() {
        parameters = new Parameters();
    }

    private void copyFile(File input, File output) throws IOException {
        FileUtils.copyFile((File)input, (File)output, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        output.setLastModified(System.currentTimeMillis());
    }

    private SynchronizerTestImpl prepareSynchronizerTest(Configuration config) {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        config.lock(LockMode.READ);
        config.unlock(LockMode.READ);
        sync.clear();
        return sync;
    }

    @Test
    void testAddConfigurationSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        config.addConfiguration((Configuration)new PropertiesConfiguration());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    void testConcurrentGetAndReload() throws Exception {
        System.getProperties().remove("Id");
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)parameters.fileBased().setFile(MULTI_TENENT_FILE)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer())});
        CombinedConfiguration config = (CombinedConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)"50", (Object)config.getString("rowsPerPage"));
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(builder, failures, i, 100, false, null, "50");
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        Assertions.assertEquals((int)0, (int)totalFailures);
    }

    @Test
    void testConcurrentGetAndReload2() throws Exception {
        System.getProperties().remove("Id");
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)parameters.fileBased().setFile(MULTI_TENENT_FILE)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer())});
        CombinedConfiguration config = (CombinedConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)"50", (Object)config.getString("rowsPerPage"));
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        System.setProperty("Id", "2002");
        Assertions.assertEquals((Object)"25", (Object)config.getString("rowsPerPage"));
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(builder, failures, i, 100, false, null, "25");
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        System.getProperties().remove("Id");
        Assertions.assertEquals((int)0, (int)totalFailures);
    }

    @Test
    void testConcurrentGetAndReloadFile() throws Exception {
        int threadCount = 25;
        System.getProperties().remove("Id");
        System.setProperty("TemporaryFolder", this.tempFolder.getAbsolutePath());
        File input = new File("target/test-classes/testMultiDynamic_default.xml");
        File output = TempDirUtils.newFile("testMultiDynamic_default.xml", this.tempFolder);
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        ReloadingCombinedConfigurationBuilder builder = new ReloadingCombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{(BuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)parameters.combined().setSynchronizer((Synchronizer)new ReadWriteSynchronizer())).setDefinitionBuilderParameters((BuilderParameters)new FileBasedBuilderParametersImpl().setFile(MULTI_DYNAMIC_FILE))).registerChildDefaultsHandler(FileBasedBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(Long.valueOf(1L))))});
        CombinedConfiguration config = builder.getConfiguration();
        Assertions.assertEquals((Object)"ID0001", (Object)config.getString("Product/FIIndex/FI[@id='123456781']"));
        ReaderThread[] testThreads = new ReaderThread[25];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReaderThread((CombinedConfigurationBuilder)builder);
            testThreads[i].start();
        }
        builder.getReloadingController().checkForReloading(null);
        Thread.sleep(2000L);
        input = new File("target/test-classes/testMultiDynamic_default2.xml");
        this.copyFile(input, output);
        Thread.sleep(2000L);
        Assertions.assertTrue((boolean)builder.getReloadingController().checkForReloading(null));
        config = builder.getConfiguration();
        String id = config.getString("Product/FIIndex/FI[@id='123456782']");
        Assertions.assertNotNull((Object)id);
        String rows = config.getString("rowsPerPage");
        Assertions.assertEquals((Object)"25", (Object)rows);
        for (ReaderThread testThread : testThreads) {
            testThread.shutdown();
            testThread.join();
        }
        for (ReaderThread testThread : testThreads) {
            Assertions.assertFalse((boolean)testThread.failed());
        }
        Assertions.assertEquals((Object)"ID0002", (Object)config.getString("Product/FIIndex/FI[@id='123456782']"));
        output.delete();
    }

    @Test
    void testConcurrentGetAndReloadMultipleClients() throws Exception {
        int i;
        System.getProperties().remove("Id");
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)parameters.fileBased().setFile(MULTI_TENENT_FILE)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer())});
        CombinedConfiguration config = (CombinedConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)"50", (Object)config.getString("rowsPerPage"));
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        String[] ids = new String[]{null, "2002", "3001", "3002", "3003"};
        String[] expected = new String[]{"50", "25", "15", "25", "50"};
        for (int i2 = 0; i2 < testThreads.length; ++i2) {
            testThreads[i2] = new ReloadThread(builder, failures, i2, 100, true, ids[i2], expected[i2]);
            testThreads[i2].start();
        }
        int totalFailures = 0;
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        System.getProperties().remove("Id");
        if (totalFailures != 0) {
            System.out.println("Failures:");
            for (i = 0; i < testThreads.length; ++i) {
                System.out.println("Thread " + i + " " + failures[i]);
            }
        }
        Assertions.assertEquals((int)0, (int)totalFailures);
    }

    @Test
    void testConfiguration() throws Exception {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler(',');
        config.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        XPathExpressionEngine engine = new XPathExpressionEngine();
        config.setExpressionEngine((ExpressionEngine)engine);
        config.setKeyPattern(PATTERN);
        MultiFileConfigurationBuilder multiBuilder = new MultiFileConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((MultiFileBuilderParameters)((MultiFileBuilderParameters)parameters.multiFile().setFilePattern(PATTERN1)).setPrefixLookups(ConfigurationInterpolator.getDefaultPrefixLookups())).setManagedBuilderParameters((BuilderParameters)((XMLBuilderParameters)parameters.xml().setExpressionEngine((ExpressionEngine)engine)).setListDelimiterHandler((ListDelimiterHandler)listHandler))});
        BuilderConfigurationWrapperFactory wrapFactory = new BuilderConfigurationWrapperFactory();
        config.addConfiguration((Configuration)wrapFactory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, (ConfigurationBuilder)multiBuilder), "Multi");
        XMLConfiguration xml = new XMLConfiguration();
        xml.setExpressionEngine((ExpressionEngine)engine);
        FileHandler handler = new FileHandler((FileBased)xml);
        handler.setFile(new File(DEFAULT_FILE));
        handler.load();
        config.addConfiguration((Configuration)xml, "Default");
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        Assertions.assertEquals((Object)"a,b,c", (Object)config.getString("split/list3/@values"));
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("split/list3/@values"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list4/@values"));
        Assertions.assertEquals((Object)"OK-1", (Object)config.getString("buttons/name"));
        Assertions.assertEquals((int)3, (int)config.getMaxIndex("buttons/name"));
        Assertions.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list2"));
        Assertions.assertEquals((int)18, (int)config.size());
        config.addProperty("listDelimiterTest", (Object)"1,2,3");
        Assertions.assertEquals((Object)"1", (Object)config.getString("listDelimiterTest"));
    }

    @Test
    void testGetConfigurationByIdxSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        PropertiesConfiguration child = new PropertiesConfiguration();
        config.addConfiguration((Configuration)child);
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        Assertions.assertSame((Object)child, (Object)config.getConfiguration(0));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testGetConfigurationByNameSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        Assertions.assertNull((Object)config.getConfiguration("unknown config"));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testGetConfigurationNamesSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        config.getConfigurationNames();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testGetNumberOfConfigurationsSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        config.getNumberOfConfigurations();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testRemoveConfigurationSynchronized() {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        String configName = "testConfig";
        config.addConfiguration((Configuration)new PropertiesConfiguration(), "testConfig");
        SynchronizerTestImpl sync = this.prepareSynchronizerTest((Configuration)config);
        config.removeConfiguration("testConfig");
        sync.verifyContains(SynchronizerTestImpl.Methods.BEGIN_WRITE);
    }

    @Test
    void testUpdateConfiguration() throws ConfigurationException {
        System.getProperties().remove("Id");
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)parameters.fileBased().setFile(MULTI_TENENT_FILE)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer())});
        CombinedConfiguration config = (CombinedConfiguration)builder.getConfiguration();
        config.getConfiguration(1).setProperty("rowsPerPage", (Object)"25");
        Assertions.assertEquals((Object)"25", (Object)config.getString("rowsPerPage"));
    }

    private void verify(String key, DynamicCombinedConfiguration config, int rows) {
        System.setProperty("Id", key);
        Assertions.assertEquals((int)config.getInt("rowsPerPage"), (int)rows);
    }

    private static final class ReloadThread
    extends Thread {
        private final CombinedConfigurationBuilder builder;
        private final int[] failures;
        private final int index;
        private final int count;
        private final String expected;
        private final String id;
        private final boolean useId;
        private final Random random;

        ReloadThread(CombinedConfigurationBuilder b, int[] failures, int index, int count, boolean useId, String id, String expected) {
            this.builder = b;
            this.failures = failures;
            this.index = index;
            this.count = count;
            this.expected = expected;
            this.id = id;
            this.useId = useId;
            this.random = new Random();
        }

        @Override
        public void run() {
            this.failures[this.index] = 0;
            if (this.useId) {
                ThreadLookup.setId(this.id);
            }
            for (int i = 0; i < this.count; ++i) {
                try {
                    CombinedConfiguration combined;
                    String value;
                    if (this.random.nextBoolean()) {
                        this.builder.resetResult();
                    }
                    if ((value = (combined = (CombinedConfiguration)this.builder.getConfiguration()).getString("rowsPerPage", null)) != null && value.equals(this.expected)) continue;
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                    continue;
                }
                catch (Exception ex) {
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                }
            }
        }
    }

    private final class ReaderThread
    extends Thread {
        private volatile boolean running = true;
        private volatile boolean failed;
        private final CombinedConfigurationBuilder builder;
        private final Random random;

        public ReaderThread(CombinedConfigurationBuilder b) {
            this.builder = b;
            this.random = new Random();
        }

        public boolean failed() {
            return this.failed;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    CombinedConfiguration combined = (CombinedConfiguration)this.builder.getConfiguration();
                    String bcId = combined.getString("Product/FIIndex/FI[@id='123456781']");
                    if ("ID0001".equalsIgnoreCase(bcId)) {
                        if (this.failed) {
                            System.out.println("Thread failed, but recovered");
                        }
                        this.failed = false;
                    } else {
                        this.failed = true;
                    }
                    int sleepTime = this.random.nextInt(75);
                    Thread.sleep(sleepTime);
                }
            }
            catch (ConfigurationException cex) {
                this.failed = true;
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }
    }

    public static class ThreadLookup
    implements Lookup {
        private static final ThreadLocal<String> ID = new ThreadLocal();

        public static void setId(String value) {
            ID.set(value);
        }

        public String lookup(String key) {
            if (key == null || !key.equals("Id")) {
                return null;
            }
            String value = System.getProperty("Id");
            if (value != null) {
                return value;
            }
            return ID.get();
        }
    }
}

