/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.settings;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.commons.settings.Setting;
import org.apache.juneau.commons.settings.Settings;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class StringSetting
extends Setting<String> {
    public StringSetting(Settings settings, Supplier<String> supplier) {
        super(settings, supplier);
    }

    public StringSetting mapString(Function<? super String, ? extends String> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        return new StringSetting(this.getSettings(), () -> {
            String value = (String)this.get();
            return Utils.nn(value) ? (String)mapper.apply(value) : null;
        });
    }

    public StringSetting filter(Predicate<? super String> predicate) {
        AssertionUtils.assertArgNotNull("predicate", predicate);
        return new StringSetting(this.getSettings(), () -> {
            String value = (String)this.get();
            return Utils.nn(value) && predicate.test(value) ? value : null;
        });
    }

    public Setting<Integer> asInteger() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Integer.valueOf(v)))).filter(Objects::nonNull);
    }

    public Setting<Long> asLong() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Long.valueOf(v)))).filter(Objects::nonNull);
    }

    public Setting<Boolean> asBoolean() {
        return this.map((T v) -> Boolean.parseBoolean(v));
    }

    public Setting<Double> asDouble() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Double.valueOf(v)))).filter(Objects::nonNull);
    }

    public Setting<Float> asFloat() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Float.valueOf(v)))).filter(Objects::nonNull);
    }

    public Setting<File> asFile() {
        return this.map((T v) -> new File((String)v));
    }

    public Setting<Path> asPath() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Paths.get(v, new String[0])))).filter(Objects::nonNull);
    }

    public Setting<URI> asURI() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> URI.create(v)))).filter(Objects::nonNull);
    }

    public Setting<Charset> asCharset() {
        return ((Setting)this.map((T v) -> Utils.safeOrNull(() -> Charset.forName(v)))).filter(Objects::nonNull);
    }

    public <T> Setting<T> asType(Class<T> c) {
        AssertionUtils.assertArgNotNull("c", c);
        return ((Setting)this.map((T v) -> this.getSettings().toType((String)v, c))).filter(Objects::nonNull);
    }
}

