/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedDataFormatMBean;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed DataFormat")
public class ManagedDataFormat
implements ManagedInstance,
ManagedDataFormatMBean {
    private final CamelContext camelContext;
    private final DataFormat dataFormat;

    public ManagedDataFormat(CamelContext camelContext, DataFormat dataFormat) {
        this.camelContext = camelContext;
        this.dataFormat = dataFormat;
    }

    public void init(ManagementStrategy strategy) {
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public String getName() {
        if (this.dataFormat instanceof DataFormatName) {
            return ((DataFormatName)this.dataFormat).getDataFormatName();
        }
        return null;
    }

    public String getCamelId() {
        return this.camelContext.getName();
    }

    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    public String getState() {
        if (this.dataFormat instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.dataFormat).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public DataFormat getInstance() {
        return this.dataFormat;
    }
}

