/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb4;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.mongodb4.MongoDb4Connection;
import org.apache.logging.log4j.mongodb4.MongoDb4DocumentObjectCodec;
import org.apache.logging.log4j.mongodb4.MongoDb4LevelCodec;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

@Plugin(name="MongoDb4", category="Core", printObject=true)
public final class MongoDb4Provider
implements NoSqlProvider<MongoDb4Connection> {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    static final String PLUGIN_NAME = "MongoDb4";
    private static final CodecRegistry CODEC_REGISTRIES = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{MongoDb4LevelCodec.INSTANCE}), CodecRegistries.fromCodecs((Codec[])new Codec[]{new MongoDb4DocumentObjectCodec()})});
    private static final long DEFAULT_COLLECTION_SIZE = 0x20000000L;
    private final Long collectionSize;
    private final boolean isCapped;
    private final String collectionName;
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;
    private final ConnectionString connectionString;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private MongoDb4Provider(String connectionStringSource, String databaseName, String collectionName, boolean isCapped, Long collectionSize) {
        this.connectionString = MongoDb4Provider.createConnectionString(connectionStringSource);
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(this.connectionString).codecRegistry(CODEC_REGISTRIES).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)settings);
        this.mongoDatabase = MongoDb4Provider.createDatabase(this.connectionString, databaseName, this.mongoClient);
        this.isCapped = isCapped;
        this.collectionSize = collectionSize;
        this.collectionName = MongoDb4Provider.getEffectiveCollectionName(this.connectionString, collectionName);
        LOGGER.debug("instantiated {}", (Object)this);
    }

    private static ConnectionString createConnectionString(String connectionStringSource) {
        try {
            return new ConnectionString(connectionStringSource);
        }
        catch (IllegalArgumentException error) {
            String message = String.format("Invalid MongoDB connection string: `%s`", connectionStringSource);
            throw new IllegalArgumentException(message, error);
        }
    }

    private static MongoDatabase createDatabase(ConnectionString connectionString, String databaseName, MongoClient client) {
        String effectiveDatabaseName = databaseName != null ? databaseName : connectionString.getDatabase();
        try {
            MongoNamespace.checkDatabaseNameValidity((String)effectiveDatabaseName);
        }
        catch (IllegalArgumentException error) {
            String message = String.format("Invalid MongoDB database name: `%s`", effectiveDatabaseName);
            throw new IllegalArgumentException(message, error);
        }
        return client.getDatabase(effectiveDatabaseName);
    }

    private static String getEffectiveCollectionName(ConnectionString connectionString, String collectionName) {
        String effectiveCollectionName = collectionName != null ? collectionName : connectionString.getCollection();
        try {
            MongoNamespace.checkCollectionNameValidity((String)effectiveCollectionName);
        }
        catch (IllegalArgumentException error) {
            String message = String.format("Invalid MongoDB collection name: `%s`", effectiveCollectionName);
            throw new IllegalArgumentException(message, error);
        }
        return effectiveCollectionName;
    }

    public MongoDb4Connection getConnection() {
        return new MongoDb4Connection(this.connectionString, this.mongoClient, this.mongoDatabase, this.collectionName, this.isCapped, this.collectionSize);
    }

    public String toString() {
        return String.format("%s [connectionString=`%s`, collectionSize=%s, isCapped=%s, databaseName=`%s`, collectionName=`%s`]", MongoDb4Provider.class.getSimpleName(), this.connectionString, this.collectionSize, this.isCapped, this.mongoDatabase.getName(), this.collectionName);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<MongoDb4Provider> {
        @PluginBuilderAttribute(value="connection")
        @Required(message="No connection string provided")
        private String connectionStringSource;
        @PluginBuilderAttribute
        private long collectionSize = 0x20000000L;
        @PluginBuilderAttribute(value="capped")
        private boolean capped = false;
        @PluginBuilderAttribute(value="collectionName")
        private String collectionName;
        @PluginBuilderAttribute(value="databaseName")
        private String databaseName;

        public MongoDb4Provider build() {
            LOGGER.warn("The {} Appender is deprecated, use the MongoDb Appender instead.", (Object)MongoDb4Provider.PLUGIN_NAME);
            return this.newMongoDb4Provider();
        }

        protected MongoDb4Provider newMongoDb4Provider() {
            return new MongoDb4Provider(this.connectionStringSource, this.databaseName, this.collectionName, this.capped, this.collectionSize);
        }

        public B setConnectionStringSource(String connectionStringSource) {
            this.connectionStringSource = connectionStringSource;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCapped(boolean isCapped) {
            this.capped = isCapped;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(int sizeInBytes) {
            this.collectionSize = sizeInBytes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(long sizeInBytes) {
            this.collectionSize = sizeInBytes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionName(String collectionName) {
            this.collectionName = collectionName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

