/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.javadoc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import jpt.sun.source.doctree.DocCommentTree;
import jpt.sun.source.doctree.DocTree;
import jpt.sun.source.doctree.ErroneousTree;
import jpt.sun.source.doctree.ParamTree;
import jpt.sun.source.doctree.ReferenceTree;
import jpt.sun.source.doctree.SeeTree;
import jpt.sun.source.doctree.TextTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.DocSourcePositions;
import jpt.sun.source.util.DocTreePath;
import jpt.sun.source.util.DocTreePathScanner;
import jpt.sun.source.util.DocTrees;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.Elements;
import jpt30.lang.model.util.Types;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.base.javadoc.JavadocCompletionUtils;
import org.netbeans.modules.java.editor.base.javadoc.Utilities;
import org.openide.util.Exceptions;

public final class JavadocImports {
    private static final String CLASS_KEYWORD = "class";
    private static final Set<String> ALL_REF_TAG_NAMES = new HashSet<String>(Arrays.asList("@link", "@linkplain", "@value", "@see", "@throws"));
    private static final Set<ElementKind> EXECUTABLE = EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR);

    private JavadocImports() {
    }

    public static Set<String> computeUnresolvedImports(CompilationInfo javac) {
        UnresolvedImportScanner scanner = new UnresolvedImportScanner(javac);
        scanner.scan(javac.getCompilationUnit(), null);
        return scanner.unresolved;
    }

    public static Set<TypeElement> computeReferencedElements(final CompilationInfo javac, TreePath tp) {
        final DocTrees trees = javac.getDocTrees();
        final DocCommentTree docComment = trees.getDocCommentTree(tp);
        if (docComment == null) {
            return Collections.emptySet();
        }
        final HashSet<TypeElement> result = new HashSet<TypeElement>();
        DocSourcePositions positions = trees.getSourcePositions();
        new DocTreePathScanner<Void, Void>(){
            boolean prevTagError = false;

            @Override
            public Void scan(DocTree node, Void p) {
                DocTreePath[] docTreePath = new DocTreePath[1];
                if (node != null && node.getKind() == DocTree.Kind.ERRONEOUS && ((ErroneousTree)node).getBody().endsWith("@")) {
                    this.prevTagError = true;
                    JavadocContext jdctx = new JavadocContext();
                    JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((ErroneousTree)node).getBody(), jdctx, javac);
                    if (jdctx.typeElement != null) {
                        result.add(jdctx.typeElement);
                    }
                    return (Void)super.scan(node, p);
                }
                if (node != null && node.getKind() == DocTree.Kind.TEXT && this.prevTagError) {
                    JavadocContext jdctx = new JavadocContext();
                    JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((TextTree)node).getBody(), jdctx, javac);
                    if (jdctx.typeElement != null) {
                        result.add(jdctx.typeElement);
                    }
                }
                this.prevTagError = false;
                return (Void)super.scan(node, p);
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                new ErrorAwareTreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        Element el = trees.getElement(this.getCurrentPath());
                        if (el != null && (el.getKind().isClass() || el.getKind().isInterface())) {
                            result.add((TypeElement)el);
                        }
                        return (Void)super.visitIdentifier(node, p);
                    }

                    @Override
                    public Void scan(Iterable<? extends TreePath> toAnalyze, Void p) {
                        for (TreePath treePath : toAnalyze) {
                            this.scan(treePath, p);
                        }
                        return null;
                    }
                }.scan((Iterable<TreePath>)JavadocImports.referenceEmbeddedSourceNodes(javac, this.getCurrentPath()), null);
                return (Void)super.visitReference(node, p);
            }

            @Override
            public Void visitSee(SeeTree node, Void p) {
                return (Void)super.visitSee(node, p);
            }
        }.scan(new DocTreePath(tp, docComment), (Void)null);
        return result;
    }

    public static List<Token> computeTokensOfReferencedElements(final CompilationInfo javac, final TreePath forElement, final Element toFind) {
        final DocTrees trees = javac.getDocTrees();
        final DocCommentTree docComment = javac.getDocTrees().getDocCommentTree(forElement);
        if (docComment == null) {
            return Collections.emptyList();
        }
        final ArrayList<Token> result = new ArrayList<Token>();
        new DocTreePathScanner<Void, Void>(){
            boolean prevTagError = false;
            private TokenSequence<JavadocTokenId> javadoc;

            @Override
            public Void scan(DocTree node, Void p) {
                DocTreePath[] docTreePath = new DocTreePath[1];
                if (node != null && node.getKind() == DocTree.Kind.ERRONEOUS && ((ErroneousTree)node).getBody().endsWith("@")) {
                    this.prevTagError = true;
                    JavadocContext jdctx = new JavadocContext();
                    JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((ErroneousTree)node).getBody(), jdctx, javac);
                    if (jdctx.typeElement != null && jdctx.typeElement.toString().equals(toFind.toString())) {
                        String[] splitPkgCls = jdctx.typeElement.toString().split("\\.");
                        if (splitPkgCls.length > 0) {
                            String endMemberName = splitPkgCls[splitPkgCls.length - 1];
                            long startPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, node);
                            startPosition = (long)jdctx.typeElement.toString().indexOf(endMemberName) + startPosition + (long)((TextTree)node).getBody().indexOf(jdctx.typeElement.toString());
                            this.handleUsage((int)startPosition);
                        }
                    } else if (jdctx.variableElements.contains(toFind)) {
                        long startPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, node);
                        this.handleUsage((int)(startPosition += (long)((TextTree)node).getBody().indexOf(toFind.toString())));
                    }
                    return (Void)super.scan(node, p);
                }
                if (node != null && node.getKind() == DocTree.Kind.TEXT && this.prevTagError) {
                    String[] splitPkgCls;
                    JavadocContext jdctx = new JavadocContext();
                    JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((TextTree)node).getBody(), jdctx, javac);
                    if (jdctx.typeElement != null && jdctx.typeElement.toString().equals(toFind.toString()) && (splitPkgCls = jdctx.typeElement.toString().split("\\.")).length > 0) {
                        String endMemberName = splitPkgCls[splitPkgCls.length - 1];
                        long startPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, node);
                        startPosition = (long)jdctx.typeElement.toString().indexOf(endMemberName) + startPosition + (long)((TextTree)node).getBody().indexOf(jdctx.typeElement.toString());
                        this.handleUsage((int)startPosition);
                    }
                    this.prevTagError = false;
                }
                this.prevTagError = false;
                if (node != null) {
                    return (Void)super.scan(node, p);
                }
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                final ReferenceTree parentNode = node;
                new ErrorAwareTreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        if (toFind.equals(trees.getElement(this.getCurrentPath()))) {
                            int startPosition = (int)trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), node);
                            if (startPosition == 0 && parentNode.toString().contains(node.toString())) {
                                long parentNodeStartPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, parentNode);
                                startPosition = (int)((long)parentNode.toString().indexOf(node.toString()) + parentNodeStartPosition);
                            }
                            this.handleUsage(startPosition);
                        }
                        return null;
                    }

                    @Override
                    public Void visitMemberSelect(MemberSelectTree node, Void p) {
                        if (toFind.equals(trees.getElement(this.getCurrentPath()))) {
                            String[] splitPkgCls;
                            int[] span = javac.getTreeUtilities().findNameSpan(node);
                            if (span != null) {
                                this.handleUsage(span[0]);
                            } else if (parentNode.toString().contains(node.toString()) && (splitPkgCls = node.toString().split("\\.")).length > 0) {
                                String endMemberName = splitPkgCls[splitPkgCls.length - 1];
                                long startPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, parentNode);
                                startPosition = (long)parentNode.toString().indexOf(endMemberName) + startPosition;
                                this.handleUsage((int)startPosition);
                            }
                            return null;
                        }
                        return (Void)super.visitMemberSelect(node, p);
                    }

                    @Override
                    public Void scan(Iterable<? extends TreePath> toAnalyze, Void p) {
                        for (TreePath treePath : toAnalyze) {
                            this.scan(treePath, p);
                        }
                        return null;
                    }
                }.scan((Iterable<TreePath>)JavadocImports.referenceEmbeddedSourceNodes(javac, this.getCurrentPath()), null);
                if (toFind.equals(trees.getElement(this.getCurrentPath()))) {
                    int[] span = javac.getTreeUtilities().findNameSpan(docComment, node);
                    if (span != null) {
                        this.handleUsage(span[0]);
                    }
                    return null;
                }
                return (Void)super.visitReference(node, p);
            }

            private void handleUsage(int start) {
                if (this.javadoc == null) {
                    this.javadoc = JavadocImports.getJavadocTS(javac, start);
                    if (this.javadoc == null) {
                        return;
                    }
                }
                this.javadoc.move(start);
                if (this.javadoc.moveNext()) {
                    result.add(this.javadoc.token());
                }
            }

            @Override
            public Void visitParam(ParamTree node, Void p) {
                if (node.getName() != null && toFind.equals(JavadocImports.paramElementFor(trees.getElement(forElement), node))) {
                    this.handleUsage((int)trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), docComment, node.getName()));
                    return null;
                }
                return (Void)super.visitParam(node, p);
            }

            @Override
            public Void visitSee(SeeTree node, Void p) {
                return (Void)super.visitSee(node, p);
            }
        }.scan(new DocTreePath(forElement, docComment), (Void)null);
        return result;
    }

    private static Element paramElementFor(Element methodOrClass, ParamTree ptag) {
        ElementKind kind = methodOrClass.getKind();
        List<Object> params = Collections.emptyList();
        if (kind == ElementKind.METHOD || kind == ElementKind.CONSTRUCTOR) {
            ExecutableElement ee = (ExecutableElement)methodOrClass;
            params = ptag.isTypeParameter() ? ee.getTypeParameters() : ee.getParameters();
        } else if (kind.isClass() || kind.isInterface()) {
            TypeElement te = (TypeElement)methodOrClass;
            params = te.getTypeParameters();
        }
        for (Element element : params) {
            if (!element.getSimpleName().contentEquals(ptag.getName().getName())) continue;
            return element;
        }
        return null;
    }

    public static Element findReferencedElement(final CompilationInfo javac, final int offset) {
        final DocTrees trees = javac.getDocTrees();
        final TreePath tp = JavadocCompletionUtils.findJavadoc(javac, offset);
        if (tp == null) {
            return null;
        }
        final DocCommentTree docComment = javac.getDocTrees().getDocCommentTree(tp);
        if (docComment == null) {
            return null;
        }
        final DocSourcePositions positions = trees.getSourcePositions();
        final Element[] result = new Element[1];
        new DocTreePathScanner<Void, Void>(){
            boolean prevTagError = false;

            @Override
            public Void scan(DocTree node, Void p) {
                DocTreePath[] docTreePath = new DocTreePath[1];
                if (node != null && node.getKind() == DocTree.Kind.ERRONEOUS && ((ErroneousTree)node).getBody().endsWith("@")) {
                    this.prevTagError = true;
                    if (positions.getStartPosition(javac.getCompilationUnit(), docComment, node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node) >= (long)offset) {
                        JavadocContext jdctx = new JavadocContext();
                        JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((ErroneousTree)node).getBody(), jdctx, javac);
                        if (!jdctx.variableElements.isEmpty()) {
                            jdctx.variableElements.forEach(ve -> {
                                result2[0] = ve;
                            });
                        }
                        return null;
                    }
                    return (Void)super.scan(node, p);
                }
                if (node != null && node.getKind() == DocTree.Kind.TEXT && this.prevTagError && positions.getStartPosition(javac.getCompilationUnit(), docComment, node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node) >= (long)offset) {
                    JavadocContext jdctx = new JavadocContext();
                    JavadocImports.processDocTreeNode(docTreePath, node, p, trees, this.getCurrentPath(), docComment, ((TextTree)node).getBody(), jdctx, javac);
                    if (jdctx.typeElement != null) {
                        long startPosition = positions.getStartPosition(javac.getCompilationUnit(), docComment, node);
                        startPosition = (long)node.toString().indexOf(jdctx.typeElement.getSimpleName().toString()) + startPosition;
                        long endPosition = startPosition + (long)jdctx.typeElement.getSimpleName().toString().length();
                        if (startPosition <= (long)offset && endPosition >= (long)offset) {
                            result[0] = jdctx.typeElement;
                            return null;
                        }
                        startPosition = (long)node.toString().indexOf(jdctx.typeElement.getEnclosingElement().toString()) + positions.getStartPosition(javac.getCompilationUnit(), docComment, node);
                        endPosition = startPosition + (long)jdctx.typeElement.getEnclosingElement().toString().length();
                        if (startPosition <= (long)offset && endPosition >= (long)offset) {
                            result[0] = jdctx.typeElement.getEnclosingElement();
                            return null;
                        }
                    }
                    this.prevTagError = false;
                    return null;
                }
                this.prevTagError = false;
                if (node != null && positions.getStartPosition(javac.getCompilationUnit(), docComment, node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node) >= (long)offset) {
                    return (Void)super.scan(node, p);
                }
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                final ReferenceTree parentNode = node;
                int[] span = javac.getTreeUtilities().findNameSpan(docComment, node);
                if (span != null && span[0] <= offset && span[1] >= offset) {
                    result[0] = trees.getElement(this.getCurrentPath());
                    return null;
                }
                new ErrorAwareTreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        if (positions.getStartPosition(javac.getCompilationUnit(), node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), node) >= (long)offset) {
                            result[0] = trees.getElement(this.getCurrentPath());
                        } else {
                            long startPosition = positions.getStartPosition(javac.getCompilationUnit(), node);
                            long endPosition = positions.getEndPosition(javac.getCompilationUnit(), node);
                            if (startPosition == 0L && endPosition == -1L && parentNode != null && parentNode.toString().contains(node.toString())) {
                                long parentNodeStartPosition = positions.getStartPosition(javac.getCompilationUnit(), docComment, parentNode);
                                startPosition = (long)parentNode.toString().indexOf(node.toString()) + parentNodeStartPosition;
                                endPosition = startPosition + (long)node.toString().length();
                                if (startPosition <= (long)offset && endPosition >= (long)offset) {
                                    result[0] = trees.getElement(this.getCurrentPath());
                                }
                            }
                        }
                        return null;
                    }

                    @Override
                    public Void visitMemberSelect(MemberSelectTree node, Void p) {
                        String[] splitPkgCls;
                        int[] span = javac.getTreeUtilities().findNameSpan(node);
                        if (span != null && span[0] <= offset && span[1] >= offset) {
                            result[0] = trees.getElement(this.getCurrentPath());
                            return null;
                        }
                        if (parentNode != null && parentNode.toString().contains(node.toString()) && (splitPkgCls = node.toString().split("\\.")).length > 0) {
                            String endMemberName = splitPkgCls[splitPkgCls.length - 1];
                            long startPosition = positions.getStartPosition(javac.getCompilationUnit(), docComment, parentNode);
                            startPosition = (long)parentNode.toString().indexOf(endMemberName) + startPosition;
                            long endPosition = startPosition + (long)node.toString().length();
                            if (startPosition <= (long)offset && endPosition >= (long)offset) {
                                result[0] = trees.getElement(this.getCurrentPath());
                                return null;
                            }
                        }
                        return (Void)super.visitMemberSelect(node, p);
                    }

                    @Override
                    public Void visitMemberReference(MemberReferenceTree node, Void p) {
                        return (Void)super.visitMemberReference(node, p);
                    }

                    @Override
                    public Void scan(Iterable<? extends TreePath> toAnalyze, Void p) {
                        for (TreePath treePath : toAnalyze) {
                            this.scan(treePath, p);
                        }
                        return null;
                    }
                }.scan((Iterable<TreePath>)JavadocImports.referenceEmbeddedSourceNodes(javac, this.getCurrentPath()), null);
                return (Void)super.visitReference(node, p);
            }

            @Override
            public Void visitParam(ParamTree node, Void p) {
                if (node.getName() != null && positions.getStartPosition(javac.getCompilationUnit(), docComment, node.getName()) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node.getName()) >= (long)offset) {
                    result[0] = JavadocImports.paramElementFor(trees.getElement(tp), node);
                    return null;
                }
                return (Void)super.visitParam(node, p);
            }

            @Override
            public Void visitSee(SeeTree node, Void p) {
                return (Void)super.visitSee(node, p);
            }
        }.scan(new DocTreePath(tp, docComment), (Void)null);
        return result[0];
    }

    public static Token findNameTokenOfReferencedElement(final CompilationInfo javac, final int offset) {
        DocTrees trees = javac.getDocTrees();
        TreePath tp = JavadocCompletionUtils.findJavadoc(javac, offset);
        if (tp == null) {
            return null;
        }
        final DocCommentTree docComment = javac.getDocTrees().getDocCommentTree(tp);
        if (docComment == null) {
            return null;
        }
        final DocSourcePositions positions = trees.getSourcePositions();
        final Token[] result = new Token[1];
        new DocTreePathScanner<Void, Void>(){

            @Override
            public Void scan(DocTree node, Void p) {
                if (node != null && positions.getStartPosition(javac.getCompilationUnit(), docComment, node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node) >= (long)offset) {
                    return (Void)super.scan(node, p);
                }
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                int[] span = javac.getTreeUtilities().findNameSpan(docComment, node);
                if (span != null && span[0] <= offset && span[1] >= offset) {
                    this.handleUsage(offset);
                    return null;
                }
                new ErrorAwareTreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        if (positions.getStartPosition(javac.getCompilationUnit(), node) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), node) >= (long)offset) {
                            this.handleUsage(offset);
                        }
                        return null;
                    }

                    @Override
                    public Void visitMemberSelect(MemberSelectTree node, Void p) {
                        int[] span = javac.getTreeUtilities().findNameSpan(node);
                        if (span != null && span[0] <= offset && span[1] >= offset) {
                            this.handleUsage(offset);
                            return null;
                        }
                        return (Void)super.visitMemberSelect(node, p);
                    }

                    @Override
                    public Void visitMemberReference(MemberReferenceTree node, Void p) {
                        return (Void)super.visitMemberReference(node, p);
                    }

                    @Override
                    public Void scan(Iterable<? extends TreePath> toAnalyze, Void p) {
                        for (TreePath treePath : toAnalyze) {
                            this.scan(treePath, p);
                        }
                        return null;
                    }
                }.scan((Iterable<TreePath>)JavadocImports.referenceEmbeddedSourceNodes(javac, this.getCurrentPath()), null);
                return (Void)super.visitReference(node, p);
            }

            private void handleUsage(int start) {
                TokenSequence<JavadocTokenId> javadoc = JavadocImports.getJavadocTS(javac, start);
                if (javadoc == null) {
                    return;
                }
                javadoc.move(start);
                if (javadoc.moveNext()) {
                    result[0] = javadoc.token();
                }
            }

            @Override
            public Void visitParam(ParamTree node, Void p) {
                if (node.getName() != null && positions.getStartPosition(javac.getCompilationUnit(), docComment, node.getName()) <= (long)offset && positions.getEndPosition(javac.getCompilationUnit(), docComment, node.getName()) >= (long)offset) {
                    result[0] = JavadocImports.findNameTokenOfParamTag(offset, JavadocImports.getJavadocTS(javac, offset));
                    return null;
                }
                return (Void)super.visitParam(node, p);
            }

            @Override
            public Void visitSee(SeeTree node, Void p) {
                return (Void)super.visitSee(node, p);
            }
        }.scan(new DocTreePath(tp, docComment), (Void)null);
        return result[0];
    }

    private static Token<JavadocTokenId> findNameTokenOfParamTag(int startPos, TokenSequence<JavadocTokenId> jdTokenSequence) {
        Token<JavadocTokenId> result = null;
        if (JavadocImports.isInsideParamName(jdTokenSequence, startPos)) {
            int delta = jdTokenSequence.move(startPos);
            if (jdTokenSequence.moveNext() && (JavadocTokenId.IDENT == jdTokenSequence.token().id() || JavadocTokenId.HTML_TAG == jdTokenSequence.token().id()) || delta == 0 && jdTokenSequence.movePrevious() && (JavadocTokenId.IDENT == jdTokenSequence.token().id() || JavadocTokenId.HTML_TAG == jdTokenSequence.token().id())) {
                result = jdTokenSequence.token();
            }
        }
        return result;
    }

    public static boolean isInsideReference(TokenSequence<JavadocTokenId> jdts, int pos) {
        int delta = jdts.move(pos);
        if (jdts.moveNext() && JavadocTokenId.IDENT == jdts.token().id() || delta == 0 && jdts.movePrevious() && JavadocTokenId.IDENT == jdts.token().id()) {
            boolean isBeforeWS = false;
            block6: while (jdts.movePrevious()) {
                Token<JavadocTokenId> jdt = jdts.token();
                switch (jdt.id()) {
                    case DOT: 
                    case HASH: 
                    case IDENT: {
                        if (!isBeforeWS) continue block6;
                        return false;
                    }
                    case OTHER_TEXT: {
                        isBeforeWS |= JavadocCompletionUtils.isWhiteSpace(jdt);
                        if (isBeforeWS |= JavadocCompletionUtils.isLineBreak(jdts)) continue block6;
                        return false;
                    }
                    case TAG: {
                        return isBeforeWS && JavadocImports.isReferenceTag(jdt);
                    }
                    case HTML_TAG: {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isInsideParamName(TokenSequence<JavadocTokenId> jdts, int pos) {
        int delta = jdts.move(pos);
        if ((jdts.moveNext() && (JavadocTokenId.IDENT == jdts.token().id() || JavadocTokenId.HTML_TAG == jdts.token().id()) || delta == 0 && jdts.movePrevious() && (JavadocTokenId.IDENT == jdts.token().id() || JavadocTokenId.HTML_TAG == jdts.token().id())) && jdts.movePrevious() && JavadocTokenId.OTHER_TEXT == jdts.token().id() && jdts.movePrevious() && JavadocTokenId.TAG == jdts.token().id()) {
            return "@param".contentEquals(jdts.token().text());
        }
        return false;
    }

    private static boolean isReferenceTag(Token<JavadocTokenId> tag) {
        String tagName = tag.text().toString().intern();
        return tag.id() == JavadocTokenId.TAG && ALL_REF_TAG_NAMES.contains(tagName);
    }

    private static TokenSequence<JavadocTokenId> getJavadocTS(CompilationInfo javac, int start) {
        TokenSequence<JavadocTokenId> javadoc = null;
        TokenSequence<JavaTokenId> ts = SourceUtils.getJavaTokenSequence(javac.getTokenHierarchy(), start);
        if (ts.moveNext() && (ts.token().id() == JavaTokenId.JAVADOC_COMMENT || ts.token().id() == JavaTokenId.JAVADOC_COMMENT_LINE_RUN)) {
            javadoc = ts.embedded(JavadocTokenId.language());
        }
        return javadoc;
    }

    private static Iterable<? extends TreePath> referenceEmbeddedSourceNodes(CompilationInfo info, DocTreePath ref) {
        List<? extends Tree> params;
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (info.getTreeUtilities().getReferenceClass(ref) != null) {
            result.add(new TreePath(ref.getTreePath(), info.getTreeUtilities().getReferenceClass(ref)));
        }
        if ((params = info.getTreeUtilities().getReferenceParameters(ref)) != null) {
            for (Tree tree : params) {
                result.add(new TreePath(ref.getTreePath(), tree));
            }
        }
        return result;
    }

    private static void processDocTreeNode(DocTreePath[] result, DocTree node, Void p, DocTrees trees, DocTreePath path, DocCommentTree dcComment, String body, JavadocContext jdctx, CompilationInfo javac) throws IllegalArgumentException {
        try {
            result[0] = new DocTreePath(path, node);
            jdctx.doc = javac.getDocument();
            jdctx.javac = javac;
            long startPosition = trees.getSourcePositions().getStartPosition(javac.getCompilationUnit(), dcComment, node);
            int errorBodyLength = body.trim().length();
            int caretOffset = (int)startPosition + errorBodyLength;
            TreePath javadocFor = result[0].getTreePath();
            if (javadocFor == null) {
                return;
            }
            jdctx.javadocFor = javadocFor;
            DocCommentTree docCommentTree = result[0].getDocComment();
            if (docCommentTree == null) {
                return;
            }
            jdctx.comment = docCommentTree;
            Element elm = trees.getElement(javadocFor);
            if (elm == null) {
                return;
            }
            jdctx.handle = ElementHandle.create(elm);
            jdctx.commentFor = elm;
            jdctx.jdts = JavadocCompletionUtils.findJavadocTokenSequence(javac, caretOffset);
            if (jdctx.jdts == null) {
                return;
            }
            jdctx.jdts.move(caretOffset);
            if (!jdctx.jdts.moveNext() && !jdctx.jdts.movePrevious()) {
                return;
            }
            if (caretOffset - jdctx.jdts.offset() == 0) {
                jdctx.jdts.movePrevious();
            }
            jdctx.positions = trees.getSourcePositions();
            if (jdctx.positions != null) {
                JavadocImports.insideTag(result[0], jdctx, caretOffset);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void insideTag(DocTreePath tag, JavadocContext jdctx, int caretOffset) {
        boolean isThrowsKind;
        TokenSequence<JavadocTokenId> jdts = jdctx.jdts;
        assert (jdts.token() != null);
        int start = (int)jdctx.positions.getStartPosition(jdctx.javac.getCompilationUnit(), jdctx.comment, tag.getLeaf());
        boolean bl = isThrowsKind = JavadocCompletionUtils.normalizedKind(tag.getLeaf()) == DocTree.Kind.THROWS;
        if (isThrowsKind && !EXECUTABLE.contains((Object)jdctx.commentFor.getKind())) {
            return;
        }
        jdts.move(start + (JavadocCompletionUtils.isBlockTag(tag) ? 0 : 1));
        if (!jdts.moveNext()) return;
        if (caretOffset <= jdts.offset() + jdts.token().length()) {
            return;
        }
        if (!jdts.moveNext()) return;
        if (caretOffset <= jdts.offset()) {
            return;
        }
        boolean noPrefix = false;
        if (caretOffset <= jdts.offset() + jdts.token().length()) {
            CharSequence cs;
            int pos = caretOffset - jdts.offset();
            cs = pos < (cs = jdts.token().text()).length() ? cs.subSequence(0, pos) : cs;
            if (JavadocCompletionUtils.isWhiteSpace(cs)) return;
            if (!JavadocCompletionUtils.isLineBreak(jdts, pos)) return;
            return;
        }
        if (!JavadocCompletionUtils.isWhiteSpace(jdts.token()) && !JavadocCompletionUtils.isLineBreak(jdts)) {
            return;
        }
        if (!jdts.moveNext()) return;
        int end = (int)jdctx.positions.getEndPosition(jdctx.javac.getCompilationUnit(), jdctx.comment, tag.getLeaf());
        JavadocImports.insideReference(JavadocCompletionUtils.normalizedKind(tag.getLeaf()), jdts.offset(), end, jdctx, caretOffset);
    }

    private static void insideReference(DocTree.Kind enclosingKind, int start, int end, JavadocContext jdctx, int caretOffset) {
        CharSequence cs = JavadocCompletionUtils.getCharSequence(jdctx.doc, start, end);
        StringBuilder sb = new StringBuilder();
        for (int i = caretOffset - start - 1; i >= 0; --i) {
            char c = cs.charAt(i);
            if (c == '#') {
                int substitutionOffset;
                String prefix = sb.toString();
                jdctx.anchorOffset = substitutionOffset = caretOffset - sb.length();
                if (i == 0) {
                    return;
                }
                TypeElement scopeType = jdctx.commentFor.getKind().isClass() || jdctx.commentFor.getKind().isInterface() ? (TypeElement)jdctx.commentFor : jdctx.javac.getElementUtilities().enclosingTypeElement(jdctx.commentFor);
                TypeMirror type = jdctx.javac.getTreeUtilities().parseType(cs.subSequence(0, i).toString(), scopeType);
                type.getKind();
                if (enclosingKind == DocTree.Kind.VALUE) {
                    if (type.getKind() == TypeKind.DECLARED) {
                        jdctx.declaredType.add(type.toString());
                    } else if (type.getKind() == TypeKind.ERROR) {
                        jdctx.errorType.add(type.toString());
                    }
                    JavadocImports.addMemberConstants(jdctx, prefix.trim(), substitutionOffset, type, caretOffset);
                    jdctx.typeElement = jdctx.javac.getElements().getTypeElement(type.toString());
                }
                return;
            }
            if (c == '.') {
                int substitutionOffset;
                String prefix = sb.toString();
                String fqn = cs.subSequence(0, i).toString();
                jdctx.anchorOffset = substitutionOffset = caretOffset - sb.length();
                if (enclosingKind == DocTree.Kind.THROWS) {
                    return;
                }
                JavadocImports.completeClassOrPkg(fqn, prefix, substitutionOffset, jdctx, caretOffset);
                return;
            }
            sb.insert(0, c);
        }
        String prefix = sb.toString();
        TypeElement scopeType = jdctx.commentFor.getKind().isClass() || jdctx.commentFor.getKind().isInterface() ? (TypeElement)jdctx.commentFor : jdctx.javac.getElementUtilities().enclosingTypeElement(jdctx.commentFor);
        TypeMirror type = jdctx.javac.getTreeUtilities().parseType(cs.subSequence(0, caretOffset - start).toString(), scopeType);
        if (type.toString().contains(prefix)) {
            jdctx.typeElement = jdctx.javac.getElements().getTypeElement(type.toString());
        }
        if (enclosingKind == DocTree.Kind.TEXT) {
            if (type.getKind() == TypeKind.DECLARED) {
                jdctx.declaredType.add(type.toString());
            } else if (type.getKind() == TypeKind.ERROR) {
                jdctx.errorType.add(type.toString());
            }
        }
    }

    private static void completeClassOrPkg(String fqn, String prefix, int substitutionOffset, JavadocContext jdctx, int caretOffset) {
        Object pkgPrefix;
        if (fqn == null) {
            pkgPrefix = prefix;
        } else {
            pkgPrefix = fqn + "." + prefix;
            TypeElement typeElm = jdctx.javac.getElements().getTypeElement(fqn);
            if (typeElm != null) {
                // empty if block
            }
        }
        jdctx.typeElement = jdctx.javac.getElements().getTypeElement((CharSequence)pkgPrefix);
    }

    private static void addMemberConstants(final JavadocContext env, final String prefix, int substitutionOffset, TypeMirror type, int caretOffset) {
        CompilationInfo controller = env.javac;
        final Trees trees = controller.getTrees();
        final Elements elements = controller.getElements();
        Types types = controller.getTypes();
        TreeUtilities tu = controller.getTreeUtilities();
        TypeElement typeElem = type.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)type).asElement() : null;
        Element docelm = env.handle.resolve(controller);
        TreePath docpath = docelm != null ? trees.getPath(docelm) : null;
        final Scope scope = docpath != null ? trees.getScope(docpath) : tu.scopeFor(caretOffset);
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            @Override
            public boolean accept(Element e, TypeMirror t) {
                switch (e.getKind()) {
                    case FIELD: {
                        String name = e.getSimpleName().toString();
                        if (((VariableElement)e).getConstantValue() != null && Utilities.startsWith(name, prefix) && !JavadocImports.CLASS_KEYWORD.equals(name) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e))) {
                            env.variableElements.add((VariableElement)e);
                        }
                        return ((VariableElement)e).getConstantValue() != null && Utilities.startsWith(name, prefix) && !JavadocImports.CLASS_KEYWORD.equals(name) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e));
                    }
                    case ENUM_CONSTANT: {
                        return ((VariableElement)e).getConstantValue() != null && Utilities.startsWith(e.getSimpleName().toString(), prefix) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(e)) && trees.isAccessible(scope, e, (DeclaredType)t);
                    }
                }
                return false;
            }
        };
        for (Element element : controller.getElementUtilities().getMembers(type, acceptor)) {
            switch (element.getKind()) {
                case FIELD: 
                case ENUM_CONSTANT: {
                    TypeMirror tm = type.getKind() == TypeKind.DECLARED ? types.asMemberOf((DeclaredType)type, element) : element.asType();
                    env.variableElements.add((VariableElement)element);
                }
            }
        }
    }

    private static final class UnresolvedImportScanner
    extends ErrorAwareTreePathScanner<Void, Void> {
        private final CompilationInfo javac;
        private Set<String> unresolved = new HashSet<String>();

        public UnresolvedImportScanner(CompilationInfo javac) {
            this.javac = javac;
        }

        @Override
        public Void visitClass(ClassTree node, Void p) {
            this.resolveElement();
            return (Void)super.visitClass(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            this.resolveElement();
            return (Void)super.visitMethod(node, p);
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            this.resolveElement();
            return (Void)super.visitVariable(node, p);
        }

        private void resolveElement() {
            final DocTrees trees = this.javac.getDocTrees();
            final DocCommentTree dcComment = trees.getDocCommentTree(this.getCurrentPath());
            if (dcComment == null) {
                return;
            }
            new DocTreePathScanner<Void, Void>(){
                boolean prevTagError = false;

                @Override
                public Void visitReference(ReferenceTree node, Void p) {
                    new ErrorAwareTreePathScanner<Void, Void>(){

                        @Override
                        public Void visitIdentifier(IdentifierTree node, Void p) {
                            Element el = trees.getElement(this.getCurrentPath());
                            if (el == null || el.asType().getKind() == TypeKind.ERROR) {
                                unresolved.add(node.getName().toString());
                            } else if (el.getKind() == ElementKind.PACKAGE) {
                                String s = ((PackageElement)el).getQualifiedName().toString();
                                if (javac.getElements().getPackageElement(s) == null) {
                                    unresolved.add(node.getName().toString());
                                }
                            }
                            return (Void)super.visitIdentifier(node, p);
                        }

                        @Override
                        public Void scan(Iterable<? extends TreePath> toAnalyze, Void p) {
                            for (TreePath treePath : toAnalyze) {
                                this.scan(treePath, p);
                            }
                            return null;
                        }
                    }.scan((Iterable<TreePath>)JavadocImports.referenceEmbeddedSourceNodes(javac, this.getCurrentPath()), null);
                    return (Void)super.visitReference(node, p);
                }

                @Override
                public Void scan(DocTree node, Void p) {
                    DocTreePath[] result = new DocTreePath[1];
                    if (node != null && node.getKind() == DocTree.Kind.ERRONEOUS && ((ErroneousTree)node).getBody().endsWith("@")) {
                        this.prevTagError = true;
                        return (Void)super.scan(node, p);
                    }
                    if (node != null && node.getKind() == DocTree.Kind.TEXT && this.prevTagError) {
                        JavadocContext jdctx = new JavadocContext();
                        JavadocImports.processDocTreeNode(result, node, p, trees, this.getCurrentPath(), dcComment, ((TextTree)node).getBody(), jdctx, javac);
                        if (!jdctx.errorType.isEmpty()) {
                            jdctx.errorType.forEach(error -> unresolved.add((String)error));
                        }
                    }
                    this.prevTagError = false;
                    return (Void)super.scan(node, p);
                }
            }.scan(new DocTreePath(this.getCurrentPath(), dcComment), (Void)null);
        }
    }

    static final class JavadocContext {
        int anchorOffset = -1;
        ElementHandle<Element> handle;
        TypeElement typeElement;
        Element commentFor;
        DocCommentTree comment;
        DocSourcePositions positions;
        TokenSequence<JavadocTokenId> jdts;
        Document doc;
        CompilationInfo javac;
        private TreePath javadocFor;
        Set<String> declaredType = new HashSet<String>();
        Set<String> errorType = new HashSet<String>();
        Set<VariableElement> variableElements = new HashSet<VariableElement>();

        JavadocContext() {
        }
    }
}

