/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenVisitor;
import org.openide.util.Utilities;

public class ComputeOverriding {
    static final Logger LOG = Logger.getLogger(ComputeOverriding.class.getName());
    private final AtomicBoolean cancel;
    private static final Map<Reference<Elements>, DataHolder> CACHE = new HashMap<Reference<Elements>, DataHolder>();

    public ComputeOverriding(AtomicBoolean cancel) {
        this.cancel = cancel;
    }

    public static AnnotationType detectOverrides(CompilationInfo info, TypeElement type, ExecutableElement ee, List<ElementDescription> result) {
        Map<ElementHandle<ExecutableElement>, List<ElementDescription>> method2Overriding = ComputeOverriding.compute(info, ElementHandle.create(type), new AtomicBoolean());
        List<ElementDescription> res = method2Overriding.get(ElementHandle.create(ee));
        if (res != null) {
            result.addAll(res);
        }
        if (!result.isEmpty()) {
            for (ElementDescription ed : result) {
                if (ed.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                return AnnotationType.OVERRIDES;
            }
            return AnnotationType.IMPLEMENTS;
        }
        return null;
    }

    public Map<ElementHandle<? extends Element>, List<ElementDescription>> process(CompilationInfo info) {
        IsOverriddenVisitor v = new IsOverriddenVisitor(info, this.cancel);
        CompilationUnitTree unit = info.getCompilationUnit();
        long startTime1 = System.currentTimeMillis();
        v.scan(unit, null);
        long endTime1 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden Scanner", new Object[]{info.getFileObject(), endTime1 - startTime1});
        HashMap<ElementHandle<? extends Element>, List<ElementDescription>> result = new HashMap<ElementHandle<? extends Element>, List<ElementDescription>>();
        for (ElementHandle<TypeElement> td : v.type2Declaration.keySet()) {
            if (this.isCanceled()) {
                return null;
            }
            Map<ElementHandle<ExecutableElement>, List<ElementDescription>> overrides = ComputeOverriding.compute(info, td, this.cancel);
            if (overrides == null) continue;
            result.putAll(overrides);
        }
        return this.isCanceled() ? null : result;
    }

    private synchronized boolean isCanceled() {
        return this.cancel.get();
    }

    private static void sortOutMethods(CompilationInfo info, Map<Name, List<ExecutableElement>> where, Element td, boolean current) {
        if (current) {
            HashMap<Name, List> newlyAdded = new HashMap<Name, List>();
            block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(td.getEnclosedElements())) {
                Name name = executableElement.getSimpleName();
                List<ExecutableElement> alreadySeen = where.get(name);
                if (alreadySeen != null) {
                    for (ExecutableElement seen : alreadySeen) {
                        if (!info.getElements().overrides(seen, executableElement, (TypeElement)seen.getEnclosingElement())) continue;
                        continue block0;
                    }
                }
                newlyAdded.computeIfAbsent(name, k -> new ArrayList()).add(executableElement);
            }
            for (Map.Entry entry : newlyAdded.entrySet()) {
                List<ExecutableElement> lee = where.get(entry.getKey());
                if (lee == null) {
                    where.put((Name)entry.getKey(), (List)entry.getValue());
                    continue;
                }
                lee.addAll((Collection)entry.getValue());
            }
        }
        for (TypeMirror typeMirror : info.getTypes().directSupertypes(td.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            ComputeOverriding.sortOutMethods(info, where, ((DeclaredType)typeMirror).asElement(), true);
        }
    }

    private static Map<ElementHandle<ExecutableElement>, List<ElementDescription>> compute(CompilationInfo info, ElementHandle<TypeElement> forType, AtomicBoolean cancel) {
        DataHolder data = ComputeOverriding.getDataFromCache(info);
        Map<ElementHandle<ExecutableElement>, List<ElementDescription>> result = data.data.get(forType);
        if (result == null) {
            result = new HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>>();
            data.data.put(forType, result);
            if (cancel.get()) {
                return null;
            }
            LOG.log(Level.FINE, "type: {0}", forType.getQualifiedName());
            HashMap<Name, List<ExecutableElement>> name2Method = new HashMap<Name, List<ExecutableElement>>();
            TypeElement resolvedType = forType.resolve(info);
            if (resolvedType == null) {
                return result;
            }
            ComputeOverriding.sortOutMethods(info, name2Method, resolvedType, false);
            for (ExecutableElement ee : ElementFilter.methodsIn(resolvedType.getEnclosedElements())) {
                List lee;
                if (cancel.get()) {
                    return null;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "method: {0}", ee.toString());
                }
                if ((lee = (List)name2Method.get(ee.getSimpleName())) == null || lee.isEmpty()) continue;
                HashSet<ExecutableElement> seenMethods = new HashSet<ExecutableElement>();
                LinkedList<ElementDescription> descriptions = new LinkedList<ElementDescription>();
                for (ExecutableElement overridee : lee) {
                    if (!info.getElements().overrides(ee, overridee, SourceUtils.getEnclosingTypeElement(ee)) || !seenMethods.add(overridee)) continue;
                    descriptions.add(new ElementDescription(info, overridee, false));
                }
                if (descriptions.isEmpty()) continue;
                result.put(ElementHandle.create(ee), descriptions);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataHolder getDataFromCache(CompilationInfo info) {
        Elements elements = info.getElements();
        Map<Reference<Elements>, DataHolder> map = CACHE;
        synchronized (map) {
            Iterator<Map.Entry<Reference<Elements>, DataHolder>> it = CACHE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Reference<Elements>, DataHolder> e = it.next();
                if (e.getKey().get() == elements) {
                    return e.getValue();
                }
                it.remove();
            }
            DataHolder holder = new DataHolder();
            CACHE.put(new CleaningWR(info.getElements()), new DataHolder());
            return holder;
        }
    }

    private static final class DataHolder {
        private final Map<ElementHandle<TypeElement>, Map<ElementHandle<ExecutableElement>, List<ElementDescription>>> data = new HashMap<ElementHandle<TypeElement>, Map<ElementHandle<ExecutableElement>, List<ElementDescription>>>();
    }

    private static final class CleaningWR
    extends WeakReference<Elements>
    implements Runnable {
        public CleaningWR(Elements el) {
            super(el, Utilities.activeReferenceQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<Reference<Elements>, DataHolder> map = CACHE;
            synchronized (map) {
                CACHE.remove(this);
            }
        }
    }
}

