/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.formats.muc.MucNameContentHandler;
import opennlp.tools.formats.muc.SgmlParser;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class MucNameSampleStream
extends FilterObjectStream<String, NameSample> {
    private final Tokenizer tokenizer;
    private final List<NameSample> storedSamples = new ArrayList<NameSample>();

    protected MucNameSampleStream(Tokenizer tokenizer, ObjectStream<String> samples) {
        super(samples);
        this.tokenizer = tokenizer;
    }

    @Override
    public NameSample read() throws IOException {
        String document;
        if (this.storedSamples.isEmpty() && (document = (String)this.samples.read()) != null) {
            document = document.replace(">>", ">");
            new SgmlParser().parse(new StringReader(document), new MucNameContentHandler(this.tokenizer, this.storedSamples));
        }
        if (!this.storedSamples.isEmpty()) {
            return this.storedSamples.remove(0);
        }
        return null;
    }
}

