/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public abstract class GremlinValueComparator
implements Comparator<Object> {
    public static final GremlinValueComparator ORDERABILITY = new GremlinValueComparator(){

        @Override
        public int compare(Object f, Object s) {
            if (f == null || s == null) {
                return f == s ? 0 : (f == null ? -1 : 1);
            }
            Type ft = Type.type(f);
            Type st = f.getClass().equals(s.getClass()) || f instanceof Number && s instanceof Number ? ft : Type.type(s);
            return ft != st ? ft.priority() - st.priority() : this.comparator(ft).compare(f, s);
        }

        @Override
        public boolean equals(Object f, Object s) {
            return this.compare(f, s) == 0;
        }
    };
    public static final GremlinValueComparator COMPARABILITY = new GremlinValueComparator(){

        @Override
        public int compare(Object f, Object s) {
            if (!2.comparable(f, s)) {
                throw new IllegalStateException("Objects are not comparable");
            }
            Type type = Type.type(f);
            return this.comparator(type).compare(f, s);
        }

        @Override
        public boolean equals(Object f, Object s) {
            if (!(f == null || s == null || f.hashCode() == s.hashCode() || f instanceof Number || f instanceof Collection || f instanceof Map)) {
                return false;
            }
            if (this.containersOfDifferentSize(f, s)) {
                return false;
            }
            if (!2.comparable(f, s)) {
                return false;
            }
            Type type = Type.type(f);
            return this.comparator(type).compare(f, s) == 0;
        }

        private boolean containersOfDifferentSize(Object f, Object s) {
            if (f instanceof Collection && s instanceof Collection && ((Collection)f).size() != ((Collection)s).size()) {
                return true;
            }
            return f instanceof Path && s instanceof Path && ((Path)f).size() != ((Path)s).size();
        }
    };
    private final Comparator<Comparable> naturalOrderComparator = Comparator.naturalOrder();
    private final Comparator<Number> numberComparator = (f, s) -> NumberHelper.compare(f, s);
    private final Comparator<Element> elementComparator = Comparator.comparing(Element::id, this);
    private final Comparator<Property> propertyComparator = Comparator.comparing(Property::key, this).thenComparing(Property::value, this);
    private final Comparator<Object> iterableComparator = (f, s) -> {
        Iterator fi = IteratorUtils.asIterator(f);
        Iterator si = IteratorUtils.asIterator(s);
        while (fi.hasNext() && si.hasNext()) {
            int i = this.compare(fi.next(), si.next());
            if (i == 0) continue;
            return i;
        }
        return fi.hasNext() ? 1 : (si.hasNext() ? -1 : 0);
    };
    private final Comparator<Set> setComparator = (s1, s2) -> {
        ArrayList l1 = new ArrayList(s1);
        ArrayList l2 = new ArrayList(s2);
        Collections.sort(l1, ORDERABILITY);
        Collections.sort(l2, ORDERABILITY);
        return this.iterableComparator.compare(l1, l2);
    };
    private final Comparator<Map> mapComparator = (m1, m2) -> {
        ArrayList l1 = new ArrayList(m1.entrySet());
        ArrayList l2 = new ArrayList(m2.entrySet());
        Collections.sort(l1, ORDERABILITY);
        Collections.sort(l2, ORDERABILITY);
        return this.iterableComparator.compare(l1, l2);
    };
    private final Comparator<Map.Entry> entryComparator = Comparator.comparing(Map.Entry::getKey, this).thenComparing(Map.Entry::getValue, this);
    private final Comparator<Object> unknownTypeComparator = (f, s) -> GremlinValueComparator.naturallyComparable(f, s) ? GremlinValueComparator.naturallyCompare(f, s) : Comparator.comparing(o -> o.getClass().getName()).thenComparing(Object::toString).compare(f, s);
    private final Comparator<Object> nulltypeComparator = (f, s) -> 0;
    private final Map<Type, Comparator> comparators = new EnumMap<Type, Comparator>(Type.class){
        {
            this.put(Type.Nulltype, GremlinValueComparator.this.nulltypeComparator);
            this.put(Type.Boolean, GremlinValueComparator.this.naturalOrderComparator);
            this.put(Type.Number, GremlinValueComparator.this.numberComparator);
            this.put(Type.Date, GremlinValueComparator.this.naturalOrderComparator);
            this.put(Type.String, GremlinValueComparator.this.naturalOrderComparator);
            this.put(Type.UUID, GremlinValueComparator.this.naturalOrderComparator);
            this.put(Type.Vertex, GremlinValueComparator.this.elementComparator);
            this.put(Type.Edge, GremlinValueComparator.this.elementComparator);
            this.put(Type.VertexProperty, GremlinValueComparator.this.elementComparator);
            this.put(Type.Property, GremlinValueComparator.this.propertyComparator);
            this.put(Type.Path, GremlinValueComparator.this.iterableComparator);
            this.put(Type.Set, GremlinValueComparator.this.setComparator);
            this.put(Type.List, GremlinValueComparator.this.iterableComparator);
            this.put(Type.Map, GremlinValueComparator.this.mapComparator);
            this.put(Type.MapEntry, GremlinValueComparator.this.entryComparator);
            this.put(Type.Unknown, GremlinValueComparator.this.unknownTypeComparator);
        }
    };

    private static int naturallyCompare(Object f, Object s) {
        if (f instanceof Comparable && s instanceof Comparable) {
            return ((Comparable)f).compareTo(s);
        }
        if (f.equals(s)) {
            return 0;
        }
        throw new IllegalStateException("Objects are not naturally comparable");
    }

    private static boolean naturallyComparable(Object f, Object s) {
        return f instanceof Comparable && s instanceof Comparable && (f.getClass().isInstance(s) || s.getClass().isInstance(f)) || f.equals(s);
    }

    public static boolean comparable(Object f, Object s) {
        if (f == null || s == null) {
            return f == s;
        }
        if (NumberHelper.eitherAreNaN(f, s)) {
            return false;
        }
        Type ft = Type.type(f);
        Type st = Type.type(s);
        if (ft == Type.List && st == Type.List) {
            return GremlinValueComparator.contentsComparable(IteratorUtils.asIterator(f), IteratorUtils.asIterator(s));
        }
        if (ft == Type.Path && st == Type.Path) {
            return GremlinValueComparator.contentsComparable(((Path)f).iterator(), ((Path)s).iterator());
        }
        if (ft == Type.Set && st == Type.Set) {
            ArrayList l1 = new ArrayList((Set)f);
            ArrayList l2 = new ArrayList((Set)s);
            Collections.sort(l1, ORDERABILITY);
            Collections.sort(l2, ORDERABILITY);
            return GremlinValueComparator.contentsComparable(l1.iterator(), l2.iterator());
        }
        if (ft == Type.Map && st == Type.Map) {
            ArrayList l1 = new ArrayList(((Map)f).entrySet());
            ArrayList l2 = new ArrayList(((Map)s).entrySet());
            Collections.sort(l1, ORDERABILITY);
            Collections.sort(l2, ORDERABILITY);
            return GremlinValueComparator.contentsComparable(l1.iterator(), l2.iterator());
        }
        if (ft == Type.MapEntry && st == Type.MapEntry) {
            return GremlinValueComparator.comparable(((Map.Entry)f).getKey(), ((Map.Entry)s).getKey()) && GremlinValueComparator.comparable(((Map.Entry)f).getValue(), ((Map.Entry)s).getValue());
        }
        if (ft == Type.Vertex && st == Type.Vertex || ft == Type.Edge && st == Type.Edge || ft == Type.VertexProperty && st == Type.VertexProperty) {
            return GremlinValueComparator.comparable(((Element)f).id(), ((Element)s).id());
        }
        if (ft == Type.Property && st == Type.Property) {
            return GremlinValueComparator.comparable(((Property)f).key(), ((Property)s).key()) && GremlinValueComparator.comparable(((Property)f).value(), ((Property)s).value());
        }
        return ft == Type.Unknown && st == Type.Unknown ? GremlinValueComparator.naturallyComparable(f, s) : ft == st;
    }

    private static boolean contentsComparable(Iterator fi, Iterator si) {
        while (fi.hasNext() && si.hasNext()) {
            boolean b = GremlinValueComparator.comparable(fi.next(), si.next());
            if (b) continue;
            return false;
        }
        return !fi.hasNext() && !si.hasNext();
    }

    private GremlinValueComparator() {
    }

    protected Comparator comparator(Type type) {
        return this.comparators.get((Object)type);
    }

    @Override
    public abstract int compare(Object var1, Object var2);

    public abstract boolean equals(Object var1, Object var2);

    public static enum Type {
        Nulltype,
        Boolean(Boolean.class),
        Number(Number.class),
        Date(Date.class),
        String(String.class),
        UUID(UUID.class),
        Vertex(Vertex.class),
        Edge(Edge.class),
        VertexProperty(VertexProperty.class),
        Property(Property.class),
        Path(Path.class),
        Set(Set.class),
        List(List.class),
        Map(Map.class),
        MapEntry(Map.Entry.class),
        Unknown(Object.class);

        private final Class type;

        public static Type type(Object o) {
            if (o == null) {
                return Nulltype;
            }
            if (o.getClass().isArray()) {
                return List;
            }
            Type[] types = Type.values();
            for (int i = 1; i < types.length; ++i) {
                if (!types[i].type.isInstance(o)) continue;
                return types[i];
            }
            return Unknown;
        }

        private Type() {
            this.type = null;
        }

        private Type(Class type) {
            this.type = type;
        }

        public int priority() {
            return this.ordinal();
        }
    }
}

