/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import jakarta.el.ELResolver;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.util.HashMap;
import java.util.Map;

public class TracingELResolverPhaseListener
implements PhaseListener {
    private static final String TRACING_INFOS = TracingELResolverPhaseListener.class.getName() + "#TRACING_INFOS";

    public static void getValue(Class<? extends ELResolver> resolver) {
        ++TracingELResolverPhaseListener.getTracingInfo(resolver).getValue;
    }

    public static void getValueHit(Class<? extends ELResolver> resolver) {
        ++TracingELResolverPhaseListener.getTracingInfo(resolver).getValueHits;
    }

    public static void getType(Class<? extends ELResolver> resolver) {
        ++TracingELResolverPhaseListener.getTracingInfo(resolver).getType;
    }

    public static void getTypeHit(Class<? extends ELResolver> resolver) {
        ++TracingELResolverPhaseListener.getTracingInfo(resolver).getTypeHits;
    }

    public static TracingInfo getTracingInfo(Class<? extends ELResolver> resolver) {
        return TracingELResolverPhaseListener.getTracingInfos().computeIfAbsent(resolver, k -> new TracingInfo());
    }

    public static Map<Class<? extends ELResolver>, TracingInfo> getTracingInfos() {
        return (Map)FacesContext.getCurrentInstance().getAttributes().computeIfAbsent(TRACING_INFOS, k -> new HashMap());
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void afterPhase(PhaseEvent event) {
        ExternalContext externalContext = event.getFacesContext().getExternalContext();
        for (Map.Entry<Class<? extends ELResolver>, TracingInfo> entry : TracingELResolverPhaseListener.getTracingInfos().entrySet()) {
            TracingInfo info = entry.getValue();
            externalContext.log("### ELResolver: " + entry.getKey().getName());
            externalContext.log("    getValue - invocations " + info.getValue + "; hits: " + info.getValueHits);
            externalContext.log("    getType - invocations " + info.getType + "; hits: " + info.getTypeHits);
        }
    }

    private static class TracingInfo {
        int getValue = 0;
        int getValueHits = 0;
        int getType = 0;
        int getTypeHits = 0;

        private TracingInfo() {
        }
    }
}

